package ru.yandex.direct.web.entity.agencyofflinereport.model;

import java.time.LocalDate;
import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import ru.yandex.direct.core.entity.agencyofflinereport.model.AgencyOfflineReportKind;
import ru.yandex.direct.core.entity.agencyofflinereport.model.AgencyOfflineReportState;

@ApiModel
public class AgencyOfflineReportWebParams {

    @JsonProperty
    private LocalDateTime builtAt;

    @JsonProperty
    private String agencyLogin;

    @JsonProperty
    private AgencyOfflineReportKind reportKind;

    @JsonProperty
    private LocalDate dateStart;

    @JsonProperty
    private LocalDate dateEnd;

    @JsonProperty
    private AgencyOfflineReportState reportStatus;

    @JsonProperty
    private Long reportId;

    public AgencyOfflineReportWebParams withBuiltAt(LocalDateTime builtAt) {
        this.builtAt = builtAt;
        return this;
    }

    public AgencyOfflineReportWebParams withAgencyLogin(String agencyLogin) {
        this.agencyLogin = agencyLogin;
        return this;
    }

    public AgencyOfflineReportWebParams withReportKind(AgencyOfflineReportKind reportKind) {
        this.reportKind = reportKind;
        return this;
    }

    public AgencyOfflineReportWebParams withDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    public AgencyOfflineReportWebParams withDateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    public AgencyOfflineReportWebParams withReportId(Long fileId) {
        this.reportId = fileId;
        return this;
    }

    public AgencyOfflineReportWebParams withReportStatus(AgencyOfflineReportState reportStatus) {
        this.reportStatus = reportStatus;
        return this;
    }
}
