package ru.yandex.direct.web.entity.agencyofflinereport.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

@ApiModel
public class EnqueueReportRequestParams {
    public static final String DATE_FROM_FIELD_NAME = "dateStart";
    public static final String DATE_TO_FIELD_NAME = "dateEnd";

    @JsonProperty(DATE_FROM_FIELD_NAME)
    public LocalDate dateFrom;

    @JsonProperty(DATE_TO_FIELD_NAME)
    public LocalDate dateTo;

    public LocalDate getDateFrom() {
        return dateFrom;
    }

    public LocalDate getDateTo() {
        return dateTo;
    }

    public EnqueueReportRequestParams withDateFrom(LocalDate dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public EnqueueReportRequestParams withDateTo(LocalDate dateTo) {
        this.dateTo = dateTo;
        return this;
    }
}
