package ru.yandex.direct.web.entity.banner.controller;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.entity.banner.model.WebCheckUrlResponse;
import ru.yandex.direct.web.entity.banner.service.WebBannerUrlCheckService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@RestController
@RequestMapping(path = "ad",
        consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "ad")
public class BannerController {

    private final WebBannerUrlCheckService webBannerUrlCheckService;

    @Autowired
    public BannerController(WebBannerUrlCheckService webBannerUrlCheckService) {
        this.webBannerUrlCheckService = webBannerUrlCheckService;
    }

    @ApiOperation(value = "checkUrl", httpMethod = "POST", nickname = "checkUrl")
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebCheckUrlResponse.class)
            }
    )
    @PreAuthorizeRead
    @RequestMapping(path = "/check_url", method = RequestMethod.POST)
    public WebResponse checkUrl(
            @RequestBody List<String> urlsToCheck,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin
    ) {
        LoggerFactory.getLogger(BannerController.class).info(urlsToCheck.get(0));
        return webBannerUrlCheckService.checkUrls(urlsToCheck);
    }
}

