package ru.yandex.direct.web.entity.banner.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.banner.model.BannerHrefWithParamsResponse;
import ru.yandex.direct.web.entity.banner.service.BannerHrefWithParamsWebService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@RequestMapping(value = "/href_with_params",
    produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "href_with_params")
public class HrefWithParamsController {

    private final BannerHrefWithParamsWebService bannerHrefWithParamsWebService;

    @Autowired
    HrefWithParamsController(BannerHrefWithParamsWebService bannerHrefWithParamsWebService) {
        this.bannerHrefWithParamsWebService = bannerHrefWithParamsWebService;
    }

    @ApiOperation(value = "getHref", httpMethod = "GET", nickname = "getHref")
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = BannerHrefWithParamsResponse.class)
            }
    )
    @PreAuthorizeRead
    @DisableAutoCaptcha
    @RequestMapping(path = "/getHref", method = RequestMethod.GET)
    @ResponseBody
    public WebResponse getHref(
            @RequestParam Long adGroupId,
            @RequestParam(required = false) Long bannerId,
            @RequestParam(required = false) String bannerHref,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin
    ) {
        return bannerHrefWithParamsWebService.getBannerHrefWithParams(adGroupId, bannerId, bannerHref);
    }
}
