package ru.yandex.direct.web.entity.banner.controller;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.banner.model.BannerImageUploadResponse;
import ru.yandex.direct.web.entity.banner.model.BannerImagesUploadResponse;
import ru.yandex.direct.web.entity.banner.model.TextBannerImageUploadByUrlResponse;
import ru.yandex.direct.web.entity.banner.service.BannerImageWebService;
import ru.yandex.direct.web.entity.banner.service.TextBannerImageWebService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@RequestMapping(value = "/image", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "image")
public class ImageController {
    private final TextBannerImageWebService textBannerImageWebService;
    private final BannerImageWebService bannerImageService;

    public ImageController(TextBannerImageWebService textBannerImageWebService,
                           BannerImageWebService bannerImageService) {
        this.textBannerImageWebService = textBannerImageWebService;
        this.bannerImageService = bannerImageService;
    }

    @ApiOperation(
            value = "uploadImageByUrlForTextAd",
            httpMethod = "POST",
            nickname = "uploadImageByUrlForTextAd"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = TextBannerImageUploadByUrlResponse.class)
            }
    )

    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "text/upload_by_url", method = RequestMethod.POST, consumes =
            MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse uploadImageByUrlForTextAd(@RequestParam("url") String url,
                                                 @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN,
                                                         required = false) String subjectLogin) {
        return textBannerImageWebService.saveImage(url);
    }


    @ApiOperation(
            value = "uploadImage",
            httpMethod = "POST",
            nickname = "uploadImage"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = BannerImagesUploadResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "upload", method = RequestMethod.POST, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    @ResponseBody
    public WebResponse uploadImage(@RequestParam("files") List<MultipartFile> files,
                                   @RequestParam("image_type") String imageType,
                                   @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required =
                                           false) String subjectLogin) {
        return bannerImageService.saveImages(files, imageType);
    }

    @ApiOperation(
            value = "uploadImageByUrl",
            httpMethod = "POST",
            nickname = "uploadImageByUrl"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = BannerImageUploadResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "upload_by_url", method = RequestMethod.POST, consumes =
            MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse uploadImageByUrlForImageAd(@RequestParam("url") String url,
                                                  @RequestParam("image_type") String imageType,
                                                  @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN,
                                                          required = false) String subjectLogin) {
        return bannerImageService.saveImage(url, imageType);
    }
}
