package ru.yandex.direct.web.entity.banner.controller

import io.swagger.annotations.Api
import io.swagger.annotations.ApiOperation
import io.swagger.annotations.ApiResponse
import io.swagger.annotations.ApiResponses
import org.springframework.http.MediaType
import org.springframework.web.bind.annotation.PostMapping
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RequestParam
import org.springframework.web.bind.annotation.RestController
import org.springframework.web.multipart.MultipartFile
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite
import ru.yandex.direct.web.core.model.WebErrorResponse
import ru.yandex.direct.web.core.model.WebResponse
import ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha
import ru.yandex.direct.web.entity.banner.model.BannerImageUploadResponse
import ru.yandex.direct.web.entity.banner.model.BannerImagesUploadResponse
import ru.yandex.direct.web.entity.banner.service.BannerImageWebService

@RestController
@Api(tags = ["image"])
@RequestMapping(value = ["/image/internal_ad"], produces = [MediaType.APPLICATION_JSON_UTF8_VALUE])
open class InternalAdImageController(val bannerImageWebService: BannerImageWebService) {

    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @PostMapping(path = ["/upload"], consumes = [MediaType.MULTIPART_FORM_DATA_VALUE])
    @ApiOperation(value = "uploadImageForInternalAd", httpMethod = "POST", nickname = "uploadImageForInternalAd")
    @ApiResponses(
            ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse::class),
            ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse::class),
            ApiResponse(code = 200, message = "Ok", response = BannerImagesUploadResponse::class)
    )
    open fun upload(@RequestParam("files") files: List<MultipartFile>,
               @RequestParam("templateIds") templateIds: List<Long>,
               @RequestParam("resourceIds") resourceIds: List<Long>,
               @RequestParam(value = PARAMETER_ULOGIN, required = false) subjectLogin: String): WebResponse {
        return bannerImageWebService.saveImagesForInternalAd(templateIds, resourceIds, files)
    }

    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @PostMapping(path = ["/upload_by_url"], consumes = [MediaType.APPLICATION_JSON_UTF8_VALUE])
    @ApiOperation(value = "uploadImageByUrlForInternalAd", httpMethod = "POST", nickname = "uploadImageByUrlForInternalAd")
    @ApiResponses(
            ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse::class),
            ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse::class),
            ApiResponse(code = 200, message = "Ok", response = BannerImageUploadResponse::class)
    )
    open fun uploadByUrl(@RequestParam("url") url: String,
                    @RequestParam("templateId") templateId: Long,
                    @RequestParam("resourceId") resourceId: Long,
                    @RequestParam(value = PARAMETER_ULOGIN, required = false) subjectLogin: String): WebResponse {
        return bannerImageWebService.saveImage(url, templateId, resourceId)
    }
}