package ru.yandex.direct.web.entity.banner.converter;

import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.sitelink.model.Sitelink;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.web.entity.banner.model.WebBannerSitelink;
import ru.yandex.direct.web.entity.banner.model.WebBannerTurbolanding;

import static org.apache.commons.lang3.StringUtils.isBlank;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.utils.NumberUtils.nullIfZero;

class BannerSitelinkConverter {

    private BannerSitelinkConverter() {
    }

    @Nullable
    static SitelinkSet toCoreSitelinks(@Nullable List<WebBannerSitelink> webSitelinks) {
        if (!isFilledSitelinksPresent(webSitelinks)) {
            return null;
        }
        return new SitelinkSet().withSitelinks(mapList(webSitelinks, BannerSitelinkConverter::toCoreSitelink));
    }

    private static Sitelink toCoreSitelink(@Nullable WebBannerSitelink webSitelink) {
        if (!isSitelinkFilled(webSitelink)) {
            return null;
        }
        String href = !isBlank(webSitelink.getUrlProtocol()) && !isBlank(webSitelink.getHref()) ?
                webSitelink.getUrlProtocol() + webSitelink.getHref() :
                null;

        return new Sitelink()
                .withTitle(webSitelink.getTitle())
                .withDescription(webSitelink.getDescription())
                .withHref(href)
                // Модель WebBannerTurbolanding используется только в старом интерфейсе,
                // в новом следует использовать turbolandingId
                .withTurboLandingId(toCoreTurbolandingId(webSitelink.getTurbolanding()));
    }

    private static Long toCoreTurbolandingId(@Nullable WebBannerTurbolanding webTurbo) {
        return webTurbo == null ? null : nullIfZero(webTurbo.getId());
    }

    private static boolean isFilledSitelinksPresent(@Nullable List<WebBannerSitelink> webSitelinks) {
        return webSitelinks != null &&
                !filterList(webSitelinks, BannerSitelinkConverter::isSitelinkFilled).isEmpty();
    }

    private static boolean isSitelinkFilled(@Nullable WebBannerSitelink webSitelink) {
        return webSitelink != null && !(isBlank(webSitelink.getHref()) && webSitelink.getTurbolanding() == null);
    }
}
