package ru.yandex.direct.web.entity.banner.converter;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.vcard.model.InstantMessenger;
import ru.yandex.direct.core.entity.vcard.model.Phone;
import ru.yandex.direct.core.entity.vcard.model.PointOnMap;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.web.entity.banner.model.WebBannerVcard;

import static org.apache.commons.lang3.StringUtils.isBlank;
import static ru.yandex.direct.utils.StringUtils.nullIfBlank;
import static ru.yandex.direct.web.entity.banner.converter.BannerVcardPointOnMapConverter.toCorePointOnMap;

@ParametersAreNonnullByDefault
class BannerVcardConverter {

    private final WebBannerVcard web;
    private final Vcard result;

    static Vcard toCoreVcard(@Nullable WebBannerVcard web) {
        return new BannerVcardConverter(web).result;
    }

    private BannerVcardConverter(@Nullable WebBannerVcard web) {
        this.web = web;
        this.result = toCoreVcard();
    }

    @Nullable
    private Vcard toCoreVcard() {
        return web == null ? null : new Vcard()
                .withCompanyName(nullIfBlank(web.getName()))
                .withCountry(nullIfBlank(web.getCountry()))
                .withCity(nullIfBlank(web.getCity()))
                .withStreet(nullIfBlank(web.getStreet()))
                .withHouse(nullIfBlank(web.getHouse()))
                .withBuild(nullIfBlank(web.getBuild()))
                .withApart(nullIfBlank(web.getApart()))
                .withMetroId(web.getMetro())
                .withContactPerson(nullIfBlank(web.getContactPerson()))
                .withEmail(nullIfBlank(web.getContactEmail()))
                .withWorkTime(nullIfBlank(web.getWorkTime()))
                .withPhone(convertPhone())
                .withInstantMessenger(convertIm())
                .withExtraMessage(convertExtraMessage(web.getExtraMessage()))
                .withOgrn(nullIfBlank(web.getOgrn()))
                .withManualPoint(convertPoint());
    }

    @Nullable
    private Phone convertPhone() {
        if (isBlank(web.getCountryCode()) &&
                isBlank(web.getCityCode()) &&
                isBlank(web.getPhone()) &&
                isBlank(web.getExt())) {
            return null;
        }
        return new Phone()
                .withCountryCode(nullIfBlank(web.getCountryCode()))
                .withCityCode(nullIfBlank(web.getCityCode()))
                .withPhoneNumber(nullIfBlank(web.getPhone()))
                .withExtension(nullIfBlank(web.getExt()));
    }

    @Nullable
    private InstantMessenger convertIm() {
        if (isBlank(web.getImClient()) &&
                isBlank(web.getImLogin())) {
            return null;
        }
        return new InstantMessenger()
                .withLogin(nullIfBlank(web.getImLogin()))
                .withType(nullIfBlank(web.getImClient()));
    }

    @Nullable
    private PointOnMap convertPoint() {
        return toCorePointOnMap(web.getManualPoint(), web.getManualBounds());
    }

    @Nullable
    private String convertExtraMessage(String sourceExtraMessage) {
        if (isBlank(sourceExtraMessage)) {
            return null;
        }
        sourceExtraMessage = sourceExtraMessage.replace('\n', ' ').replace('\t', ' ');
        return nullIfBlank(sourceExtraMessage);
    }
}
