package ru.yandex.direct.web.entity.banner.converter;

import java.math.BigDecimal;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

import ru.yandex.direct.core.entity.vcard.model.PointOnMap;
import ru.yandex.direct.web.entity.banner.model.WebBannerVcard;

import static com.google.common.base.Preconditions.checkArgument;
import static org.apache.commons.lang3.StringUtils.defaultString;
import static org.apache.commons.lang3.StringUtils.isBlank;

@ParametersAreNullableByDefault
class BannerVcardPointOnMapConverter {

    private BannerVcardPointOnMapConverter() {
        // no instantiation
    }

    /**
     * @param manualPoint  координаты, строка вида "{@code XX.XXXXXX,YY.YYYYYY}"
     * @param manualBounds область, заданная двумя координатами в строковом представлении через запятую,
     *                     т.е. в виде "{@code X1.XXXXXX,Y1.YYYYYY,X2.XXXXXX,Y2.YYYYYY}".
     * @return {@link PointOnMap}, или {@code null} – если обе строки пустые или равны {@code null}.
     * @throws IllegalArgumentException если число координат отличается от ожидаемого.
     * @throws NumberFormatException    если координаты не могут быть преобразованы в десятичное число.
     */
    @Nullable
    static PointOnMap toCorePointOnMap(@Nullable String manualPoint, @Nullable String manualBounds) {
        if (isBlank(manualPoint) && isBlank(manualBounds)) {
            return null;
        }

        String[] point = defaultString(manualPoint).split(",");
        String[] bounds = defaultString(manualBounds).split(",");

        checkArgument(point.length == 2, "Expected 2 coordinates in " + WebBannerVcard.Prop.MANUAL_POINT);
        checkArgument(bounds.length == 4, "Expected 4 coordinates in " + WebBannerVcard.Prop.MANUAL_BOUNDS);

        return new PointOnMap()
                .withX(new BigDecimal(point[0].trim()))
                .withY(new BigDecimal(point[1].trim()))
                .withX1(new BigDecimal(bounds[0].trim()))
                .withY1(new BigDecimal(bounds[1].trim()))
                .withX2(new BigDecimal(bounds[2].trim()))
                .withY2(new BigDecimal(bounds[3].trim()));
    }
}
