package ru.yandex.direct.web.entity.banner.converter;

import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.web.entity.banner.model.WebContentPromotionBanner;
import ru.yandex.direct.web.entity.banner.model.WebContentPromotionBannerContentRes;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Конвертер для баннеров продвижения контента и видео-контента.
 */
public class ContentPromotionBannerConverter {

    private ContentPromotionBannerConverter() {
    }

    public static List<BannerWithSystemFields> webBannersToCoreContentPromotionBanners(
            @Nullable List<WebContentPromotionBanner> webBanners) {
        return mapList(webBanners, ContentPromotionBannerConverter::webBannerToCoreContentPromotionBanner);
    }

    @Nullable
    public static BannerWithSystemFields webBannerToCoreContentPromotionBanner(
            @Nullable WebContentPromotionBanner webBanner) {
        if (webBanner == null) {
            return null;
        }
        return createContentPromotionBanner(webBanner);
    }

    private static BannerWithSystemFields createContentPromotionBanner(WebContentPromotionBanner webBanner) {
        Long contentPromotionContentId = ifNotNull(webBanner.getContentResource(),
                WebContentPromotionBannerContentRes::getContentId);
        Long contentId = contentPromotionContentId;
        String visitUrl = webBanner.getVisitUrl();
        return toPromotionCoreBanner(webBanner, contentId, visitUrl);
    }

    private static BannerWithSystemFields toPromotionCoreBanner(WebContentPromotionBanner webBanner,
                                                                Long contentId,
                                                                String visitUrl) {
        return new ContentPromotionBanner()
                .withId(webBanner.getId())
                .withTitle(webBanner.getTitle())
                .withBody(webBanner.getDescription())
                .withContentPromotionId(contentId)
                .withVisitUrl(visitUrl);
    }
}
