package ru.yandex.direct.web.entity.banner.model;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class WebBanner {

    @SuppressWarnings("WeakerAccess")
    public static class Prop {
        private Prop() {
        }

        public static final String ID = "bid";
        public static final String AD_TYPE = "ad_type";
        public static final String BANNER_TYPE = "banner_type";
        public static final String TITLE = "title";
        public static final String TITLE_EXTENSION = "title_extension";
        public static final String BODY = "body";
        public static final String URL_PROTOCOL = "url_protocol";
        public static final String HREF = "href";
        public static final String DISPLAY_HREF = "display_href";
        public static final String DOMAIN = "domain";
        public static final String VIDEO_RESOURCES = "video_resources";
        public static final String SITELINKS = "sitelinks";
        public static final String CALLOUTS = "callouts";
        public static final String VCARD = "vcard";
        public static final String TURBOLANDING = "turbolanding";
        public static final String TURBOLANDING_HREF_PARAMS = "turbolanding_href_params";
        public static final String IMAGE_HASH = "image";
        public static final String IMAGE_AD = "image_ad";
        public static final String CREATIVE = "creative";
        public static final String BANNER_PRICE = "banner_price";
        public static final String PERMALINK_ID = "permalink";
    }

    @JsonProperty(Prop.ID)
    private Long id;

    @JsonProperty(Prop.AD_TYPE)
    private String adType;

    @JsonProperty(Prop.BANNER_TYPE)
    private String bannerType;

    @JsonProperty(Prop.TITLE)
    private String title;

    @JsonProperty(Prop.TITLE_EXTENSION)
    private String titleExtension;

    @JsonProperty(Prop.BODY)
    private String body;

    @JsonProperty(Prop.URL_PROTOCOL)
    private String urlProtocol;

    @JsonProperty(Prop.HREF)
    private String href;

    @JsonProperty(Prop.DISPLAY_HREF)
    private String displayHref;

    @JsonProperty(Prop.DOMAIN)
    private String domain;

    @JsonProperty(Prop.VIDEO_RESOURCES)
    private WebBannerVideoRes videoResources;

    @JsonProperty(Prop.SITELINKS)
    private List<WebBannerSitelink> sitelinks;

    @JsonProperty(Prop.CALLOUTS)
    private List<WebBannerCallout> callouts;

    @JsonProperty(Prop.VCARD)
    private WebBannerVcard vcard;

    @JsonProperty(Prop.TURBOLANDING)
    private WebBannerTurbolanding turbolanding;

    @JsonProperty(Prop.TURBOLANDING_HREF_PARAMS)
    private String turbolandingHrefParams;

    @JsonProperty(Prop.IMAGE_HASH)
    private String imageHash;

    @JsonProperty(Prop.IMAGE_AD)
    private WebBannerImageAd imageAd;

    @JsonProperty(Prop.CREATIVE)
    private WebBannerCreative creative;

    @JsonProperty(Prop.BANNER_PRICE)
    private WebBannerPrice bannerPrice;

    @JsonProperty(Prop.PERMALINK_ID)
    private Long permalinkId;

    public Long getId() {
        return id;
    }

    public WebBanner withId(Long id) {
        this.id = id;
        return this;
    }

    public String getAdType() {
        return adType;
    }

    public WebBanner withAdType(String adType) {
        this.adType = adType;
        return this;
    }

    public String getBannerType() {
        return bannerType;
    }

    public WebBanner withBannerType(String bannerType) {
        this.bannerType = bannerType;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public WebBanner withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitleExtension() {
        return titleExtension;
    }

    public WebBanner withTitleExtension(String titleExtension) {
        this.titleExtension = titleExtension;
        return this;
    }

    public String getBody() {
        return body;
    }

    public WebBanner withBody(String body) {
        this.body = body;
        return this;
    }

    public String getUrlProtocol() {
        return urlProtocol;
    }

    public WebBanner withUrlProtocol(String urlProtocol) {
        this.urlProtocol = urlProtocol;
        return this;
    }

    public String getHref() {
        return href;
    }

    public WebBanner withHref(String href) {
        this.href = href;
        return this;
    }

    public String getDisplayHref() {
        return displayHref;
    }

    public WebBanner withDisplayHref(String displayHref) {
        this.displayHref = displayHref;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public WebBanner withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public WebBannerVideoRes getVideoResources() {
        return videoResources;
    }

    public WebBanner withVideoResources(WebBannerVideoRes videoResources) {
        this.videoResources = videoResources;
        return this;
    }

    public List<WebBannerSitelink> getSitelinks() {
        return sitelinks;
    }

    public WebBanner withSitelinks(List<WebBannerSitelink> sitelinks) {
        this.sitelinks = sitelinks;
        return this;
    }

    public List<WebBannerCallout> getCallouts() {
        return callouts;
    }

    public WebBanner withCallouts(List<WebBannerCallout> callouts) {
        this.callouts = callouts;
        return this;
    }

    public WebBannerVcard getVcard() {
        return vcard;
    }

    public WebBanner withVcard(WebBannerVcard vcard) {
        this.vcard = vcard;
        return this;
    }

    public WebBannerTurbolanding getTurbolanding() {
        return turbolanding;
    }

    public WebBanner withTurbolanding(WebBannerTurbolanding turbolanding) {
        this.turbolanding = turbolanding;
        return this;
    }

    public String getTurbolandingHrefParams() {
        return turbolandingHrefParams;
    }

    public WebBanner withTurbolandingHrefParams(String turbolandingHrefParams) {
        this.turbolandingHrefParams = turbolandingHrefParams;
        return this;
    }

    public String getImageHash() {
        return imageHash;
    }

    public WebBanner withImageHash(String imageHash) {
        this.imageHash = imageHash;
        return this;
    }

    public WebBannerImageAd getImageAd() {
        return imageAd;
    }

    public WebBanner withImageAd(WebBannerImageAd imageAd) {
        this.imageAd = imageAd;
        return this;
    }

    public WebBannerCreative getCreative() {
        return creative;
    }

    public WebBanner withCreative(WebBannerCreative creative) {
        this.creative = creative;
        return this;
    }

    @Nullable
    public WebBannerPrice getBannerPrice() {
        return bannerPrice;
    }

    public WebBanner withBannerPrice(WebBannerPrice bannerPrice) {
        this.bannerPrice = bannerPrice;
        return this;
    }

    @Nullable
    public Long getPermalinkId() {
        return permalinkId;
    }

    public WebBanner withPermalinkId(Long permalinkId) {
        this.permalinkId = permalinkId;
        return this;
    }
}
