package ru.yandex.direct.web.entity.banner.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebBannerMeasurer {

    public static class Prop {
        private Prop() {
        }

        public static final String MEASURER_SYSTEM = "measurer_system";
        public static final String PARAMS = "params";
        public static final String HAS_INTEGRATION = "has_integration";
    }

    @JsonProperty(Prop.MEASURER_SYSTEM)
    private WebBannerMeasurerSystem measurerSystem;

    @JsonProperty(Prop.PARAMS)
    private String params;

    @JsonProperty(Prop.HAS_INTEGRATION)
    private Boolean hasIntegration;

    public WebBannerMeasurerSystem getMeasurerSystem() {
        return measurerSystem;
    }

    public WebBannerMeasurer withMeasurerSystem(WebBannerMeasurerSystem measurerSystem) {
        this.measurerSystem = measurerSystem;
        return this;
    }

    public String getParams() {
        return params;
    }

    public WebBannerMeasurer withParams(String params) {
        this.params = params;
        return this;
    }

    public Boolean getHasIntegration() {
        return hasIntegration;
    }

    public WebBannerMeasurer withHasIntegration(Boolean hasIntegration) {
        this.hasIntegration = hasIntegration;
        return this;
    }
}
