package ru.yandex.direct.web.entity.banner.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebBannerPrice {

    @SuppressWarnings("WeakerAccess")
    public static class Prop {
        private Prop() {
        }

        public static final String PREFIX = "prefix";
        public static final String PRICE = "price";
        public static final String PRICE_OLD = "priceOld";
        public static final String CURRENCY = "currency";
    }

    @JsonProperty(Prop.PREFIX)
    private String prefix;

    @JsonProperty(Prop.PRICE)
    private String price;

    @JsonProperty(Prop.PRICE_OLD)
    private String priceOld;

    @JsonProperty(Prop.CURRENCY)
    private String currency;

    public String getPrefix() {
        return prefix;
    }

    public WebBannerPrice withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getPrice() {
        return price;
    }

    public WebBannerPrice withPrice(String price) {
        this.price = price;
        return this;
    }

    public String getPriceOld() {
        return priceOld;
    }

    public WebBannerPrice withPriceOld(String priceOld) {
        this.priceOld = priceOld;
        return this;
    }

    public String getCurrency() {
        return currency;
    }

    public WebBannerPrice withCurrency(String currency) {
        this.currency = currency;
        return this;
    }
}
