package ru.yandex.direct.web.entity.banner.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebBannerSitelink {

    @SuppressWarnings("WeakerAccess")
    public static class Prop {
        private Prop() {
        }

        public static final String HREF = "href";
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String TURBOLANDING = "turbolanding";
        public static final String URL_PROTOCOL = "url_protocol";
    }

    @JsonProperty(Prop.TITLE)
    private String title;

    @JsonProperty(Prop.URL_PROTOCOL)
    private String urlProtocol;

    @JsonProperty(Prop.HREF)
    private String href;

    @JsonProperty(Prop.DESCRIPTION)
    private String description;

    @JsonProperty(Prop.TURBOLANDING)
    private WebBannerTurbolanding turbolanding;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrlProtocol() {
        return urlProtocol;
    }

    public void setUrlProtocol(String urlProtocol) {
        this.urlProtocol = urlProtocol;
    }

    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WebBannerTurbolanding getTurbolanding() {
        return turbolanding;
    }

    public void setTurbolanding(WebBannerTurbolanding turbolanding) {
        this.turbolanding = turbolanding;
    }

    public WebBannerSitelink withTitle(String title) {
        this.title = title;
        return this;
    }

    public WebBannerSitelink withUrlProtocol(String urlProtocol) {
        this.urlProtocol = urlProtocol;
        return this;
    }

    public WebBannerSitelink withHref(String href) {
        this.href = href;
        return this;
    }

    public WebBannerSitelink withDescription(String description) {
        this.description = description;
        return this;
    }

    public WebBannerSitelink withTurbolanding(WebBannerTurbolanding turbolanding) {
        this.turbolanding = turbolanding;
        return this;
    }
}
