package ru.yandex.direct.web.entity.banner.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

public class WebBannerVcard {

    @SuppressWarnings("WeakerAccess")
    public static class Prop {
        private Prop() {
        }

        public static final String COUNTRY = "country";
        public static final String CITY = "city";
        public static final String COUNTRY_CODE = "country_code";
        public static final String CITY_CODE = "city_code";
        public static final String PHONE = "phone";
        public static final String EXT = "ext";
        public static final String NAME = "name";
        public static final String CONTACT_PERSON = "contactperson";
        public static final String WORK_TIME = "worktime";
        public static final String STREET = "street";
        public static final String HOUSE = "house";
        public static final String BUILD = "build";
        public static final String APART = "apart";
        public static final String MANUAL_POINT = "manual_point";
        public static final String MANUAL_BOUNDS = "manual_bounds";
        public static final String METRO = "metro";
        public static final String CONTACT_EMAIL = "contact_email";
        public static final String IM_CLIENT = "im_client";
        public static final String IM_LOGIN = "im_login";
        public static final String EXTRA_MESSAGE = "extra_message";
        public static final String OGRN = "ogrn";
    }


    @JsonProperty(Prop.COUNTRY)
    private String country;

    @JsonProperty(Prop.CITY)
    private String city;

    @JsonProperty(Prop.COUNTRY_CODE)
    private String countryCode;

    @JsonProperty(Prop.CITY_CODE)
    private String cityCode;

    @JsonProperty(Prop.PHONE)
    private String phone;

    @JsonProperty(Prop.EXT)
    private String ext;

    @JsonProperty(Prop.NAME)
    private String name;

    @JsonProperty(Prop.CONTACT_PERSON)
    private String contactPerson;

    @JsonProperty(Prop.WORK_TIME)
    private String workTime;

    @JsonProperty(Prop.STREET)
    private String street;

    @JsonProperty(Prop.HOUSE)
    private String house;

    @JsonProperty(Prop.BUILD)
    private String build;

    @JsonProperty(Prop.APART)
    private String apart;

    @JsonProperty(Prop.MANUAL_POINT)
    private String manualPoint;

    @JsonProperty(Prop.MANUAL_BOUNDS)
    private String manualBounds;

    @JsonProperty(Prop.METRO)
    @JsonDeserialize(as = Long.class)
    private Long metro;

    @JsonProperty(Prop.CONTACT_EMAIL)
    private String contactEmail;

    @JsonProperty(Prop.IM_CLIENT)
    private String imClient;

    @JsonProperty(Prop.IM_LOGIN)
    private String imLogin;

    @JsonProperty(Prop.EXTRA_MESSAGE)
    private String extraMessage;

    @JsonProperty(Prop.OGRN)
    private String ogrn;

    public String getCountry() {
        return country;
    }

    public WebBannerVcard withCountry(String country) {
        this.country = country;
        return this;
    }

    public String getCity() {
        return city;
    }

    public WebBannerVcard withCity(String city) {
        this.city = city;
        return this;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public WebBannerVcard withCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public String getCityCode() {
        return cityCode;
    }

    public WebBannerVcard withCityCode(String cityCode) {
        this.cityCode = cityCode;
        return this;
    }

    public String getPhone() {
        return phone;
    }

    public WebBannerVcard withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getExt() {
        return ext;
    }

    public WebBannerVcard withExt(String ext) {
        this.ext = ext;
        return this;
    }

    public String getName() {
        return name;
    }

    public WebBannerVcard withName(String name) {
        this.name = name;
        return this;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public WebBannerVcard withContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
        return this;
    }

    public String getWorkTime() {
        return workTime;
    }

    public WebBannerVcard withWorkTime(String workTime) {
        this.workTime = workTime;
        return this;
    }

    public String getStreet() {
        return street;
    }

    public WebBannerVcard withStreet(String street) {
        this.street = street;
        return this;
    }

    public String getHouse() {
        return house;
    }

    public WebBannerVcard withHouse(String house) {
        this.house = house;
        return this;
    }

    public String getBuild() {
        return build;
    }

    public WebBannerVcard withBuild(String build) {
        this.build = build;
        return this;
    }

    public String getApart() {
        return apart;
    }

    public WebBannerVcard withApart(String apart) {
        this.apart = apart;
        return this;
    }

    public String getManualPoint() {
        return manualPoint;
    }

    public WebBannerVcard withManualPoint(String manualPoint) {
        this.manualPoint = manualPoint;
        return this;
    }

    public String getManualBounds() {
        return manualBounds;
    }

    public WebBannerVcard withManualBounds(String manualBounds) {
        this.manualBounds = manualBounds;
        return this;
    }

    public Long getMetro() {
        return metro;
    }

    public WebBannerVcard withMetro(Long metro) {
        this.metro = metro;
        return this;
    }

    public String getContactEmail() {
        return contactEmail;
    }

    public WebBannerVcard withContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
        return this;
    }

    public String getImClient() {
        return imClient;
    }

    public WebBannerVcard withImClient(String imClient) {
        this.imClient = imClient;
        return this;
    }

    public String getImLogin() {
        return imLogin;
    }

    public WebBannerVcard withImLogin(String imLogin) {
        this.imLogin = imLogin;
        return this;
    }

    public String getExtraMessage() {
        return extraMessage;
    }

    public WebBannerVcard withExtraMessage(String extraMessage) {
        this.extraMessage = extraMessage;
        return this;
    }

    public String getOgrn() {
        return ogrn;
    }

    public WebBannerVcard withOgrn(String ogrn) {
        this.ogrn = ogrn;
        return this;
    }
}
