package ru.yandex.direct.web.entity.banner.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.validation.model.WebDefect;

public class WebCheckUrlResponse implements WebResponse {

    @JsonProperty("check_results")
    private List<WebUrlCheckResult> checkResults;

    @JsonProperty("validation_errors")
    private List<WebDefect> validationErrors;

    public List<WebUrlCheckResult> getCheckResults() {
        return checkResults;
    }

    public void setCheckResults(List<WebUrlCheckResult> checkResults) {
        this.checkResults = checkResults;
    }

    public WebCheckUrlResponse withCheckResults(List<WebUrlCheckResult> checkResults) {
        setCheckResults(checkResults);
        return this;
    }

    public List<WebDefect> getValidationErrors() {
        return validationErrors;
    }

    public void setValidationErrors(List<WebDefect> errors) {
        this.validationErrors = errors;
    }

    public WebCheckUrlResponse withValidationErrors(List<WebDefect> errors) {
        setValidationErrors(errors);
        return this;
    }

    @Override
    public boolean isSuccessful() {
        return hasAnyValidItem();
    }

    private boolean hasAnyValidItem() {
        return validationErrors.size() != checkResults.size();
    }
}
