package ru.yandex.direct.web.entity.banner.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Веб модель баннера продвижения контента.
 */
public class WebContentPromotionBanner {

    @SuppressWarnings("WeakerAccess")
    public static class Prop {
        private Prop() {
        }

        public static final String ID = "bid";
        public static final String AD_TYPE = "ad_type";
        public static final String BANNER_TYPE = "banner_type";
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String CONTENT_RESOURCE = "content_resource";
        public static final String VISIT_URL = "visit_url";
    }

    @JsonProperty(WebContentPromotionBanner.Prop.ID)
    private Long id;

    @JsonProperty(WebContentPromotionBanner.Prop.AD_TYPE)
    private String adType;

    @JsonProperty(WebContentPromotionBanner.Prop.BANNER_TYPE)
    private String bannerType;

    @JsonProperty(WebContentPromotionBanner.Prop.TITLE)
    private String title;

    @JsonProperty(WebContentPromotionBanner.Prop.DESCRIPTION)
    private String description;

    @JsonProperty(WebContentPromotionBanner.Prop.CONTENT_RESOURCE)
    @Nullable
    private WebContentPromotionBannerContentRes contentResource;

    @JsonProperty(Prop.VISIT_URL)
    @Nullable
    private String visitUrl;


    public Long getId() {
        return id;
    }

    public WebContentPromotionBanner withId(Long id) {
        this.id = id;
        return this;
    }

    public String getAdType() {
        return adType;
    }

    public WebContentPromotionBanner withAdType(String adType) {
        this.adType = adType;
        return this;
    }

    public String getBannerType() {
        return bannerType;
    }

    public WebContentPromotionBanner withBannerType(String bannerType) {
        this.bannerType = bannerType;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public WebContentPromotionBanner withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public WebContentPromotionBanner withDescription(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public WebContentPromotionBannerContentRes getContentResource() {
        return contentResource;
    }

    public WebContentPromotionBanner withContentResource(
            @Nullable WebContentPromotionBannerContentRes contentResource) {
        this.contentResource = contentResource;
        return this;
    }

    @Nullable
    public String getVisitUrl() {
        return visitUrl;
    }

    public WebContentPromotionBanner withVisitUrl(@Nullable String visitUrl) {
        this.visitUrl = visitUrl;
        return this;
    }
}
