package ru.yandex.direct.web.entity.banner.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebCpmBanner {

    public static class Prop {
        private Prop() {
        }

        public static final String ID = "bid";
        public static final String AD_TYPE = "ad_type";
        public static final String PIXELS = "pixels";
        public static final String URL_PROTOCOL = "url_protocol";
        public static final String HREF = "href";
        public static final String CREATIVE = "creative";
        public static final String TURBOLANDING = "turbolanding";
        public static final String TURBOLANDING_HREF_PARAMS = "turbolanding_href_params";
        public static final String MEASURERS = "measurers";
        public static final String TNS_ID = "tns_id";
    }

    @JsonProperty(Prop.ID)
    private Long id;

    @JsonProperty(Prop.AD_TYPE)
    private String adType;

    @JsonProperty(Prop.PIXELS)
    private List<WebPixel> pixels;

    @JsonProperty(Prop.URL_PROTOCOL)
    private String urlProtocol;

    @JsonProperty(Prop.HREF)
    private String href;

    @JsonProperty(Prop.CREATIVE)
    private WebBannerCreative creative;

    @JsonProperty(Prop.TURBOLANDING)
    private WebBannerTurbolanding turbolanding;

    @JsonProperty(Prop.TURBOLANDING_HREF_PARAMS)
    private String turbolandingHrefParams;

    @JsonProperty(Prop.MEASURERS)
    private List<WebBannerMeasurer> measurers;

    @JsonProperty(Prop.TNS_ID)
    private String tnsId;

    public Long getId() {
        return id;
    }

    public WebCpmBanner withId(Long id) {
        this.id = id;
        return this;
    }

    public String getAdType() {
        return adType;
    }

    public WebCpmBanner withAdType(String adType) {
        this.adType = adType;
        return this;
    }

    public List<WebPixel> getPixels() {
        return pixels;
    }

    public WebCpmBanner withPixels(List<WebPixel> pixels) {
        this.pixels = pixels;
        return this;
    }

    public String getUrlProtocol() {
        return urlProtocol;
    }

    public WebCpmBanner withUrlProtocol(String urlProtocol) {
        this.urlProtocol = urlProtocol;
        return this;
    }

    public String getHref() {
        return href;
    }

    public WebCpmBanner withHref(String href) {
        this.href = href;
        return this;
    }

    public WebBannerCreative getCreative() {
        return creative;
    }

    public WebCpmBanner withCreative(WebBannerCreative creative) {
        this.creative = creative;
        return this;
    }

    public WebBannerTurbolanding getTurbolanding() {
        return turbolanding;
    }

    public WebCpmBanner withTurbolanding(WebBannerTurbolanding turbolanding) {
        this.turbolanding = turbolanding;
        return this;
    }

    public String getTurbolandingHrefParams() {
        return turbolandingHrefParams;
    }

    public WebCpmBanner withTurbolandingHrefParams(String turbolandingHrefParams) {
        this.turbolandingHrefParams = turbolandingHrefParams;
        return this;
    }

    public List<WebBannerMeasurer> getMeasurers() {
        return measurers;
    }

    public WebCpmBanner withMeasurers(List<WebBannerMeasurer> measurers) {
        this.measurers = measurers;
        return this;
    }

    public String getTnsId() {
        return tnsId;
    }

    public WebCpmBanner withTnsId(String tnsId) {
        this.tnsId = tnsId;
        return this;
    }
}
