package ru.yandex.direct.web.entity.banner.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.entity.adgroup.model.PixelKind;

public class WebPixel {
    public static class Prop {
        private Prop() {
        }

        public static final String KIND = "kind";
        public static final String URL = "url";
    }

    @JsonProperty(Prop.KIND)
    private PixelKind kind;

    @JsonProperty(Prop.URL)
    private String url;

    public PixelKind getKind() {
        return kind;
    }

    public WebPixel withKind(PixelKind kind) {
        this.kind = kind;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public WebPixel withUrl(String url) {
        this.url = url;
        return this;
    }
}
