package ru.yandex.direct.web.entity.banner.presentations;

import ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds;
import ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.web.validation.WebDefectTranslations;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ACTION_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ADD_TO_ARCHIVED_CAMPAIGN_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.AD_GROUP_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.AD_MORE_THAN_ONCE_IN_REQUEST;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.AD_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ALREADY_ARCHIVED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ALREADY_SUSPENDED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ARCHIVED_BANNER_MODIFICATION;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ARCHIVE_BANNER_SHOWN_IN_BS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ARCHIVE_DRAFT_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ARRAY_ELEMENT_INVALID_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_MODERATE_WITH_EMPTY_GROUP;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_SITELINKS_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_TYPE_MODIFICATION;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_CHANGE_BANNER_FLAGS_FROM_AGE_TO_OTHER_TYPES;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_CHANGE_BANNER_FLAGS_FROM_BABY_FOOD_TO_OTHER_TYPES;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_CHANGE_CREATIVE_ID_TO_IMAGE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_CHANGE_IMAGE_TO_CREATIVE_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_HAVE_TEMPLATE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_UPDATE_ARCHIVED_AD;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CLIENT_CANNOT_SET_BANNER_FLAGS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CLIENT_HAS_NOT_CREATIVES;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CPC_VIDEO_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CREATIVE_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.DUPLICATE_SPECIAL_CHARS_IN_DISPLAY_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.EMPTY_DISPLAY_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.EMPTY_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.EMPTY_VALUE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.FORBIDDEN_MOBILE_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ILLEGAL_COMMA;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IMAGE_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IMAGE_SIZE_INVALID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IMAGE_SIZE_MODIFICATION;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IMAGE_SIZE_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_BANNER_CID_AND_CAMPAIGN_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_BANNER_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_AND_CPM_VIDEO_AD_GROUP_SKIPPABILITY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_BUSINESS_TYPE_TO_FEED_BUSINESS_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_FORMAT;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_GEO_TO_ADGROUP_GEO;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_TYPE_TO_BANNER_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_ADGROUP_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_IMAGE_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_TURBOLANDING_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INSUFFICIENT_RIGHTS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_DISPLAY_HREF_USAGE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_DOMAIN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_SITELINK_SET_USAGE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_TEMPLATE_QUERY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IS_NOT_ARCHIVED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IS_NOT_SUSPENDED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CANVAS_OR_HTML5_TYPES;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CANVAS_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CPM_AUDIO_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CPM_VIDEO_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_HREF_OR_TURBOLANDING_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_HREF_OR_VCARD_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_HTML5_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_IMAGE_HASH_OR_CREATIVE_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_ONLY_IMAGE_OR_CREATIVE_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_VIDEO_ADDITION_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.RESTRICTED_CHARS_IN_FIELD;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.RESUME_ARCHIVED_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.RESUME_DRAFT_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.SITELINKS_SET_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.SITELINK_DOMAIN_IS_NOT_FIT_TO_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.SUSPEND_ARCHIVED_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.SUSPEND_DRAFT_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.TURBO_PAGE_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.UNSUPPORTED_BANNER_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.UNSUPPORTED_BUTTON_ACTION;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.VCARD_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.VCARD_OF_ANOTHER_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.VIDEO_EXTENSION_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.ARCHIVE_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.DUPLICATED_AD_EXTENSION_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.RESUME_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.SUSPEND_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.UNARCHIVE_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.LanguageDefect.INCONSISTENT_LANGUAGE_WITH_GEO;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Num.MAX_BANNERS_IN_ADGROUP;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Num.MAX_BANNERS_IN_INTERNAL_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Num.MAX_BANNERS_IN_UNIVERSAL_APP_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.PixelPermissions.NO_RIGHTS_TO_PIXEL;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.PixelProviderLimits.EQUAL_PIXEL_PROVIDERS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Size.MAX_CALLOUTS_ON_BANNER_ADD;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Size.MAX_CALLOUTS_PER_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Size.MAX_FOREIGN_PIXELS_ON_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Size.MAX_YA_AUD_PIXELS_ON_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.DISPLAY_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.HREF_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.INVALID_SPEC_SYMBOL;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.LENGTH_WORD_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.MAX_NUMBER_OF_NARROW_CHARACTERS_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.NO_RIGHTS_TO_AUDIENCE_PIXEL;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.RESTRICTED_CHARS_IN_DISPLAY_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.SHOULD_NOT_BE_BLANK;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.TEXT_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class BannerDefectPresentations {

    private BannerDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> bannerDefectPresentationRegistry() {
        BannerDefectTranslations translations = BannerDefectTranslations.INSTANCE;
        CommonDefectTranslations commonTranslations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(ILLEGAL_COMMA, defaultWebDefect())
                .register(SITELINK_DOMAIN_IS_NOT_FIT_TO_BANNER, defaultWebDefect())
                .register(INSUFFICIENT_RIGHTS, defaultWebDefect())
                .register(INVALID_HREF, defaultWebDefect())
                .register(INVALID_DOMAIN, defaultWebDefect())
                .register(INVALID_TEMPLATE_QUERY, defaultWebDefect())
                .register(CANNOT_HAVE_TEMPLATE, defaultWebDefect())
                .register(INVALID_DISPLAY_HREF_USAGE, defaultWebDefect())
                .register(INVALID_SITELINK_SET_USAGE, defaultWebDefect())
                .register(REQUIRED_HREF_OR_VCARD_ID, defaultWebDefect())
                .register(REQUIRED_HREF_OR_TURBOLANDING_ID, defaultWebDefect())
                .register(REQUIRED_IMAGE_HASH_OR_CREATIVE_ID, defaultWebDefect())
                .register(REQUIRED_ONLY_IMAGE_OR_CREATIVE_ID, defaultWebDefect())
                .register(CANNOT_CHANGE_IMAGE_TO_CREATIVE_ID, defaultWebDefect())
                .register(CANNOT_CHANGE_CREATIVE_ID_TO_IMAGE, defaultWebDefect())
                .register(BANNER_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY, defaultWebDefect())
                .register(BANNER_SITELINKS_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY, defaultWebDefect())
                .register(INCONSISTENT_STATE_BANNER_TYPE_AND_ADGROUP_TYPE, defaultWebDefect())
                .register(INCONSISTENT_STATE_BANNER_TYPE_AND_IMAGE_TYPE, defaultWebDefect())
                .register(INCONSISTENT_STATE_BANNER_TYPE_AND_TURBOLANDING_TYPE, defaultWebDefect())
                .register(ARCHIVED_BANNER_MODIFICATION, defaultWebDefect())
                .register(UNSUPPORTED_BANNER_TYPE, defaultWebDefect())
                .register(UNSUPPORTED_BUTTON_ACTION, defaultWebDefect())
                .register(CLIENT_HAS_NOT_CREATIVES, defaultWebDefect())
                .register(REQUIRED_VIDEO_ADDITION_TYPE_ONLY, defaultWebDefect())
                .register(REQUIRED_CPM_VIDEO_TYPE_ONLY, defaultWebDefect())
                .register(INCONSISTENT_CREATIVE_AND_CPM_VIDEO_AD_GROUP_SKIPPABILITY, defaultWebDefect())
                .register(REQUIRED_CPM_AUDIO_TYPE_ONLY, defaultWebDefect())
                .register(REQUIRED_HTML5_TYPE_ONLY, defaultWebDefect())
                .register(REQUIRED_CANVAS_OR_HTML5_TYPES, defaultWebDefect())
                .register(REQUIRED_CANVAS_TYPE_ONLY, defaultWebDefect())
                .register(INCONSISTENT_CREATIVE_TYPE_TO_BANNER_TYPE, defaultWebDefect())
                .register(INCONSISTENT_CREATIVE_BUSINESS_TYPE_TO_FEED_BUSINESS_TYPE, defaultWebDefect())
                .register(INCONSISTENT_CREATIVE_GEO_TO_ADGROUP_GEO, defaultWebDefect())
                .register(INCONSISTENT_CREATIVE_FORMAT, defaultWebDefect())
                .register(BANNER_MODERATE_WITH_EMPTY_GROUP, defaultWebDefect())
                .register(FORBIDDEN_MOBILE_BANNER, defaultWebDefect())
                .register(ACTION_IN_ARCHIVED_CAMPAIGN, defaultWebDefect())
                .register(INCONSISTENT_BANNER_CID_AND_CAMPAIGN_ID, defaultWebDefect())
                .register(HREF_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX, defaultWebDefect())
                .register(LENGTH_WORD_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX, defaultWebDefect())
                .register(MAX_BANNERS_IN_ADGROUP, defaultWebDefect())
                .register(MAX_BANNERS_IN_INTERNAL_CAMPAIGN, defaultWebDefect())
                .register(MAX_BANNERS_IN_UNIVERSAL_APP_CAMPAIGN, defaultWebDefect())
                .register(INCONSISTENT_LANGUAGE_WITH_GEO, defaultWebDefect())
                .register(MAX_NUMBER_OF_NARROW_CHARACTERS_CANNOT_BE_MORE_THAN_MAX, defaultWebDefect())
                .register(INCONSISTENT_BANNER_TYPE, defaultWebDefect())
                .register(BANNER_TYPE_MODIFICATION, defaultWebDefect())
                .register(IMAGE_NOT_FOUND, webDefect(translations.imageNotFoundDetailed()))
                .register(EMPTY_HREF, webDefect(translations.emptyHrefDetailed()))
                .register(THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
                        webDefect(translations.trackingSystemDomainNotSupported()))
                .register(THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS,
                        webDefect(translations.trackingSystemDomainSupportsHttpsOnly()))
                .register(AD_GROUP_NOT_FOUND,
                        webDefect(translations.adGroupNotFoundDetailed()))
                .register(ADD_TO_ARCHIVED_CAMPAIGN_NOT_ALLOWED,
                        webDefect(translations.addToArchivedCampaignNotAllowedDetailed()))
                .register(SITELINKS_SET_NOT_FOUND,
                        webDefect(translations.sitelinksSetNotFoundDetailed()))
                .register(TURBO_PAGE_NOT_FOUND,
                        webDefect(translations.turboPageNotFoundDetailed()))
                .register(VCARD_NOT_FOUND,
                        webDefect(translations.vcardNotFoundDetailed()))
                .register(BannerDefectIds.Id.AD_EXTENSION_NOT_FOUND,
                        paramWebDefect(di -> BannerDefectTranslations.INSTANCE.adExtensionNotFoundDetailed(
                                new Identity(di.getDefect().params().getId()))))
                .register(AD_GROUP_TYPE_NOT_SUPPORTED,
                        webDefect(commonTranslations.adGroupTypeNotSupportedDetailed()))
                .register(AD_MORE_THAN_ONCE_IN_REQUEST,
                        webDefect(translations.adMoreThanOnceInRequest()))
                .register(ARRAY_ELEMENT_INVALID_ID,
                        paramWebDefect(di -> translations.invalidIdInArrayElement(di.getPath())))
                .register(DUPLICATE_SPECIAL_CHARS_IN_DISPLAY_HREF,
                        webDefect(translations.duplicateSpecCharsInDisplayHrefDetailed()))
                .register(EMPTY_DISPLAY_HREF,
                        paramWebDefect(di -> commonTranslations.emptyDetailed(di.getPath())))
                .register(EMPTY_VALUE,
                        paramWebDefect(di -> translations.emptyValueInField(di.getPath())))
                .register(RESTRICTED_CHARS_IN_FIELD,
                        paramWebDefect(di -> commonTranslations.invalidCharsDetailed(di.getPath())))
                .register(VCARD_OF_ANOTHER_CAMPAIGN,
                        paramWebDefect(di -> translations.vcardOfAnotherCampaignDetailed()))
                .register(VIDEO_EXTENSION_NOT_FOUND,
                        webDefect(translations.videoExtNotFoundDetailed()))
                .register(CPC_VIDEO_NOT_FOUND,
                        webDefect(translations.cpcVideoNotFoundDetailed()))
                .register(DUPLICATED_AD_EXTENSION_ID,
                        paramWebDefect(di -> translations.duplicatedAdExtensionIdDetailed(modelIdIdentity(di))))
                .register(MAX_CALLOUTS_PER_BANNER,
                        paramWebDefect(di -> translations.adExtensionsPerBannerLimitExceededDetailed(
                                new Identity(di.getDefect().params().getMaxSize()))))
                .register(MAX_CALLOUTS_ON_BANNER_ADD,
                        paramWebDefect(di -> translations.adExtensionsLimitExceededDetailed(
                                new Identity(di.getDefect().params().getMaxSize()))))
                .register(MAX_YA_AUD_PIXELS_ON_BANNER,
                        paramWebDefect(di -> translations.maxYaAudiencePixelsOnBannerExceeded()))
                .register(MAX_FOREIGN_PIXELS_ON_BANNER,
                        paramWebDefect(di -> translations.maxNonYaAudiencePixelsOnBannerExceeded()))
                .register(EQUAL_PIXEL_PROVIDERS, paramWebDefect(di -> translations.equalPixelProviders(
                        di.getDefect().params().getExceededClientPixelProviderNamesJoined())))
                .register(DISPLAY_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        defaultWebDefect())
                .register(NO_RIGHTS_TO_PIXEL, defaultWebDefect())
                .register(NO_RIGHTS_TO_AUDIENCE_PIXEL, defaultWebDefect())
                .register(INVALID_SPEC_SYMBOL, defaultWebDefect())
                .register(BannerDefectIds.PixelWithMeasurer.INVALID_PIXEL_WITH_MEASURER,
                        paramWebDefect(di -> translations.invalidPixelWithMeasurer(
                                di.getDefect().params().getPixelUrl(),
                                di.getDefect().params().getMeasurerSystemName())))
                .register(RESTRICTED_CHARS_IN_DISPLAY_HREF,
                        defaultWebDefect())
                .register(SHOULD_NOT_BE_BLANK, defaultWebDefect())
                .register(TEXT_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                        defaultWebDefect())
                .register(CREATIVE_NOT_FOUND, webDefect(translations.creativeNotFound()))
                .register(CANNOT_UPDATE_ARCHIVED_AD,
                        webDefect(translations.cannotUpdateArchivedAd()))
                .register(AD_NOT_FOUND, webDefect(translations.adNotFoundDetailed()))
                .register(IMAGE_SIZE_MODIFICATION,
                        webDefect(translations.cannotUpdateImageSize()))
                .register(IMAGE_SIZE_NOT_FOUND,
                        defaultWebDefect())
                .register(IMAGE_SIZE_INVALID,
                        defaultWebDefect())
                .register(CANNOT_CHANGE_BANNER_FLAGS_FROM_BABY_FOOD_TO_OTHER_TYPES,
                        defaultWebDefect())
                .register(CANNOT_CHANGE_BANNER_FLAGS_FROM_AGE_TO_OTHER_TYPES,
                        defaultWebDefect())
                .register(CLIENT_CANNOT_SET_BANNER_FLAGS,
                        defaultWebDefect())
                .register(SUSPEND_IN_ARCHIVED_CAMPAIGN, paramWebDefect(di ->
                        translations.suspendBannerInArchivedCampaign(new Identity(di.getDefect().params().getId()))))
                .register(RESUME_IN_ARCHIVED_CAMPAIGN, paramWebDefect(di ->
                        translations.resumeBannerInArchivedCampaign(new Identity(di.getDefect().params().getId()))))
                .register(SUSPEND_ARCHIVED_BANNER, webDefect(translations.cannotSuspendArchivedBanner()))
                .register(RESUME_ARCHIVED_BANNER, webDefect(translations.cannotResumeArchivedBanner()))
                .register(SUSPEND_DRAFT_BANNER, webDefect(translations.cannotSuspendDraftBanner()))
                .register(RESUME_DRAFT_BANNER, webDefect(translations.cannotResumeDraftBanner()))
                .register(ALREADY_SUSPENDED, webDefect(translations.alreadySuspended()))
                .register(IS_NOT_SUSPENDED, webDefect(translations.isNotSuspended()))
                .register(ALREADY_ARCHIVED, webDefect(translations.alreadyArchived()))
                .register(IS_NOT_ARCHIVED, webDefect(translations.isNotArchived()))
                .register(ARCHIVE_BANNER_SHOWN_IN_BS, webDefect(translations.cannotArchiveBannerShownInBs()))
                .register(ARCHIVE_DRAFT_BANNER, webDefect(translations.cannotArchiveDraftBanner()))
                .register(ARCHIVE_IN_ARCHIVED_CAMPAIGN,
                        paramWebDefect(di -> translations.archiveInArchivedCampaign(
                                new Identity(di.getDefect().params().getId()))))
                .register(UNARCHIVE_IN_ARCHIVED_CAMPAIGN,
                        paramWebDefect(di -> translations.unarchiveInArchivedCampaign(
                                new Identity(di.getDefect().params().getId()))))
                .register(BannerDefectIds.Gen.UNABLE_TO_DELETE,
                        webDefect(translations.unableToDeleteDetailed()))
                .register(BannerDefectIds.Gen.TRACKING_URL_DOESNT_CONTAIN_MACROS,
                        webDefect(translations.trackingUrlDoesntContainMacros()))
                .register(BannerDefectIds.Gen.MODERATE_BANNER_IN_GROUP_WITHOUT_SHOW_CONDITIONS,
                        webDefect(translations.moderateBannerInAdGroupWithoutShowConditions()))
                .register(BannerDefectIds.Gen.MODERATE_ARCHIVED_BANNER,
                        webDefect(translations.moderateArchivedBanner()))
                .register(BannerDefectIds.Gen.MODERATE_NON_DRAFT_BANNER,
                        webDefect(translations.moderateNonDraftBanner()))
                .register(BannerDefectIds.Gen.REMODERATE_DRAFT_BANNER,
                        webDefect(translations.remoderateDraftBanner()))
                .register(BannerDefectIds.Gen.INVALID_PIXEL_FORMAT, defaultWebDefect())
                .register(BannerDefectIds.Id.MODERATE_BANNER_IN_ARCHIVED_CAMPAIGN, paramWebDefect(di ->
                        translations.moderateBannerInArchivedCampaign(new Identity(di.getDefect().params().getId()))))
                .register(BannerDefectIds.Gen.CANNOT_HAVE_TURBOLANDINGS, defaultWebDefect())
                .register(BannerDefectIds.Gen.CONTENT_TYPE_NOT_MATCHES_ADGROUP_CONTENT_TYPE,
                        webDefect(translations.contentTypeNotMatchesAdGroupContentType()))
                .register(BannerDefectIds.Gen.CONTENT_PROMOTION_VIDEO_IS_INACCESSIBLE,
                        webDefect(translations.contentPromotionVideoIsInaccessible()))
                .register(BannerDefectIds.Gen.CONTENT_PROMOTION_COLLECTION_IS_INACCESSIBLE,
                        webDefect(translations.contentPromotionCollectionIsInaccessible()))
                .register(BannerDefectIds.Gen.FORBIDDEN_TO_CHANGE, defaultWebDefect())
                .register(BannerDefectIds.Gen.INTERNAL_TEMPLATE_NOT_ALLOWED, defaultWebDefect())
                .register(BannerDefectIds.Gen.INTERNAL_TEMPLATE_VARIABLES_MISMATCH, defaultWebDefect())
                .register(BannerDefectIds.Gen.REQUIRED_CAMPAIGNS_IMPRESSION_RATE_BUT_EMPTY, defaultWebDefect())
                .register(BannerDefectIds.Gen.REQUIRED_AD_GROUPS_IMPRESSION_RATE_BUT_EMPTY, defaultWebDefect())
                .register(BannerDefectIds.Gen.REQUIRED_CAMPAIGN_OR_AD_GROUP_MAX_STOPS_COUNT_BUT_EMPTY,
                        defaultWebDefect())
                .register(BannerDefectIds.Gen.BANNER_PRICE_MISSING, defaultWebDefect())
                .register(BannerDefectIds.Gen.BANNER_PRICE_CURRENCY_MISSING, defaultWebDefect())
                .register(BannerDefectIds.Gen.BANNER_PRICE_GREATER_THAN_OLD, defaultWebDefect())
                .register(BannerDefectIds.Gen.BANNER_CANNOT_HAVE_TURBO_GALLERY_HREF, defaultWebDefect())
                .register(BannerDefectIds.Gen.ERRORS_WHILE_COPYING_BANNERS, defaultWebDefect())
                .register(BannerDefectIds.Price.MUST_BE_GREATER_THAN_MIN,
                        webDefect(WebDefectTranslations.INSTANCE.lessThanMinValue()))
                .register(BannerDefectIds.Price.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
                        webDefect(WebDefectTranslations.INSTANCE.maxValueExceeded()))
                .register(BannerDefectIds.Gen.PRICE_SALES_FULLNESS_VIOLATED,
                        defaultWebDefect())
                .register(BannerDefectIds.Gen.PRICE_SALES_CAMPAIGN_GEO_OVERLAPS_BANNER_MINUS_GEO,
                        defaultWebDefect())
                .register(BannerDefectIds.Gen.PRICE_SALES_DISALLOWED_CREATIVE_TEMPLATE, defaultWebDefect())
                .register(BannerDefectIds.Id.REMODERATE_BANNER_IN_DRAFT_CAMPAIGN, paramWebDefect(di ->
                        translations.remoderateBannerInDraftCampaign(new Identity(di.getDefect().params().getId()))))
                .register(BannerDefectIds.Gen.REMODERATE_BANNER_IS_NOT_ALLOWED,
                        webDefect(translations.remoderateBannerIsNotAllowed()))
                .register(BannerDefectIds.Gen.REMODERATE_BANNER_WITH_NO_MOD_REASONS,
                        webDefect(translations.remoderateBannerWithNoModReasons()))
                .register(BannerDefectIds.ModReasons.REMODERATE_BANNER_WITH_NOT_ALLOWED_MOD_REASONS,
                        webDefect(translations.remoderateBannerWithNotAllowedModReasons()))
                .register(BannerDefectIds.Gen.INCONSISTENT_LEADFORM_HREF_AND_BUTTON_TEXT, defaultWebDefect())
                .register(BannerDefectIds.Gen.DIFFERENT_TEMPLATES_NOT_ALLOWED, defaultWebDefect())
                .register(BannerDefectIds.Gen.TEMPLATE_RESOURCE_ID_NOT_FOUND, defaultWebDefect())
                .register(BannerDefectIds.Gen.TEMPLATE_MUST_BE_MODERATED, defaultWebDefect())
                .register(BannerDefectIds.Gen.INCORRECT_IMPRESSION_URL_TRACKING_SYSTEM,
                        webDefect(translations.incorrectImpressionUrlTrackingSystem()))
                .register(BannerDefectIds.Gen.INCORRECT_IMPRESSION_URL_TRACKER_ID,
                        webDefect(translations.incorrectImpressionUrlTrackerId()))
                .build();
    }

    private static Identity modelIdIdentity(DefectInfo<? extends Defect<ModelIdDefectParams>> defect) {
        return new Identity(defect.getDefect().params().getId());
    }
}
