package ru.yandex.direct.web.entity.banner.presentations;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.banner.model.WebContentPromotionBanner;
import ru.yandex.direct.web.entity.banner.model.WebContentPromotionBannerContentRes;

import static java.util.Arrays.asList;

@ParametersAreNonnullByDefault
public class ContentPromotionBannerPathConverter {

    private ContentPromotionBannerPathConverter() {
    }

    public static final MappingPathNodeConverter CONTENT_PROMOTION_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(ContentPromotionBannerPathConverter.class.getName())
                    .replace(ContentPromotionBanner.ID.name(), WebContentPromotionBanner.Prop.ID)
                    .replace(ContentPromotionBanner.TITLE.name(), WebContentPromotionBanner.Prop.TITLE)
                    .replace(ContentPromotionBanner.BODY.name(), WebContentPromotionBanner.Prop.DESCRIPTION)
                    .replace(ContentPromotionBanner.CONTENT_PROMOTION_ID.name(),
                            asList(WebContentPromotionBanner.Prop.CONTENT_RESOURCE,
                                    WebContentPromotionBannerContentRes.Prop.CONTENT_ID))
                    .build();
}
