package ru.yandex.direct.web.entity.banner.presentations;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.banner.model.WebBanner;
import ru.yandex.direct.web.entity.banner.model.WebBannerCreative;
import ru.yandex.direct.web.entity.banner.model.WebBannerTurbolanding;

import static java.util.Arrays.asList;

@ParametersAreNonnullByDefault
public class CpcVideoBannerPathConverters {

    private CpcVideoBannerPathConverters() {
    }

    public static final MappingPathNodeConverter CPC_VIDEO_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(CpcVideoBannerPathConverters.class.getName())
                    .replace(CpcVideoBanner.ID.name(), WebBanner.Prop.ID)
                    .replace(CpcVideoBanner.TURBO_LANDING_ID.name(),
                            asList(WebBanner.Prop.TURBOLANDING, WebBannerTurbolanding.Prop.ID))
                    .replace(CpcVideoBanner.CREATIVE_ID.name(),
                            asList(WebBanner.Prop.CREATIVE, WebBannerCreative.Prop.CREATIVE_ID))
                    .replace(CpcVideoBanner.HREF.name(), WebBanner.Prop.HREF)
                    .replace(CpcVideoBanner.TURBO_LANDING_HREF_PARAMS.name(), WebBanner.Prop.TURBOLANDING_HREF_PARAMS)
                    .build();
}
