package ru.yandex.direct.web.entity.banner.presentations;

import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.banner.model.WebBanner;
import ru.yandex.direct.web.entity.banner.model.WebBannerCreative;
import ru.yandex.direct.web.entity.banner.model.WebBannerTurbolanding;
import ru.yandex.direct.web.entity.banner.model.WebCpmBanner;

import static java.util.Arrays.asList;

public class CpmBannerPathConverter {

    private CpmBannerPathConverter() {
    }


    public static final MappingPathNodeConverter CPM_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(CpmBannerPathConverter.class.getName())
                    .replace(CpmBanner.ID.name(), WebCpmBanner.Prop.ID)
                    .replace(CpmBanner.TURBO_LANDING_ID.name(),
                            asList(WebCpmBanner.Prop.TURBOLANDING, WebBannerTurbolanding.Prop.ID))
                    .replace(CpmBanner.PIXELS.name(), WebCpmBanner.Prop.PIXELS)
                    .replace(CpmBanner.HREF.name(), WebCpmBanner.Prop.HREF)
                    .replace(CpmBanner.CREATIVE_ID.name(),
                            asList(WebCpmBanner.Prop.CREATIVE, WebBannerCreative.Prop.CREATIVE_ID))
                    .replace(CpmBanner.TURBO_LANDING_HREF_PARAMS.name(), WebBanner.Prop.TURBOLANDING_HREF_PARAMS)
                    .build();

}
