package ru.yandex.direct.web.entity.banner.presentations;

import ru.yandex.direct.core.entity.banner.container.ComplexBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.banner.model.WebBanner;
import ru.yandex.direct.web.entity.banner.model.WebBannerCreative;
import ru.yandex.direct.web.entity.banner.model.WebBannerTurbolanding;

import static java.util.Arrays.asList;

public class ImageBannerPathConverters {

    private ImageBannerPathConverters() {
    }

    public static final MappingPathNodeConverter IMAGE_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(ImageBannerPathConverters.class.getName())
                    .replace(ImageBanner.ID.name(), WebBanner.Prop.ID)
                    .replace(ImageBanner.CREATIVE_ID.name(),
                            asList(WebBanner.Prop.CREATIVE, WebBannerCreative.Prop.CREATIVE_ID))
                    .replace(ImageBanner.IMAGE_HASH.name(), WebBanner.Prop.IMAGE_HASH)
                    .replace(ImageBanner.HREF.name(), WebBanner.Prop.HREF)
                    .replace(ImageBanner.TURBO_LANDING_ID.name(),
                            asList(WebBanner.Prop.TURBOLANDING, WebBannerTurbolanding.Prop.ID))

                    .replace(ComplexBanner.VCARD.name(), WebBanner.Prop.VCARD)
                    .skip(ComplexBanner.SITELINK_SET.name())

                    .replace(ImageBanner.TURBO_LANDING_HREF_PARAMS.name(), WebBanner.Prop.TURBOLANDING_HREF_PARAMS)
                    .build();
}
