package ru.yandex.direct.web.entity.banner.presentations;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.container.ComplexBanner;
import ru.yandex.direct.core.entity.banner.model.BannerPrice;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.sitelink.model.Sitelink;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.entity.sitelink.turbolanding.model.SitelinkTurboLanding;
import ru.yandex.direct.core.entity.vcard.model.InstantMessenger;
import ru.yandex.direct.core.entity.vcard.model.Phone;
import ru.yandex.direct.core.entity.vcard.model.PointOnMap;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.banner.model.WebBanner;
import ru.yandex.direct.web.entity.banner.model.WebBannerCallout;
import ru.yandex.direct.web.entity.banner.model.WebBannerPrice;
import ru.yandex.direct.web.entity.banner.model.WebBannerSitelink;
import ru.yandex.direct.web.entity.banner.model.WebBannerTurbolanding;
import ru.yandex.direct.web.entity.banner.model.WebBannerVcard;
import ru.yandex.direct.web.entity.banner.model.WebBannerVideoRes;

import static java.util.Arrays.asList;

@ParametersAreNonnullByDefault
public class TextBannerPathConverter {

    private TextBannerPathConverter() {
    }

    public static final MappingPathNodeConverter TEXT_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(TextBannerPathConverter.class.getName())
                    .replace(TextBanner.ID.name(), WebBanner.Prop.ID)
                    .replace(TextBanner.IS_MOBILE.name(), WebBanner.Prop.BANNER_TYPE)
                    .replace(TextBanner.TITLE.name(), WebBanner.Prop.TITLE)
                    .replace(TextBanner.TITLE_EXTENSION.name(), WebBanner.Prop.TITLE_EXTENSION)
                    .replace(TextBanner.BODY.name(), WebBanner.Prop.BODY)
                    .replace(TextBanner.HREF.name(), WebBanner.Prop.HREF)
                    .replace(TextBanner.DISPLAY_HREF.name(), WebBanner.Prop.DISPLAY_HREF)
                    .replace(TextBanner.DOMAIN.name(), WebBanner.Prop.DOMAIN)
                    .replace(TextBanner.TURBO_LANDING_ID.name(),
                            asList(WebBanner.Prop.TURBOLANDING, WebBannerTurbolanding.Prop.ID))
                    .replace(TextBanner.VCARD_ID.name(), WebBanner.Prop.VCARD)
                    .replace(TextBanner.SITELINKS_SET_ID.name(), WebBanner.Prop.SITELINKS)

                    .replace(TextBanner.CALLOUT_IDS.name(), WebBanner.Prop.CALLOUTS)
                    .appendListItems(TextBanner.CALLOUT_IDS.name(), WebBannerCallout.Prop.ADDITIONS_ITEM_ID)

                    .replace(TextBanner.CREATIVE_ID.name(),
                            asList(WebBanner.Prop.VIDEO_RESOURCES, WebBannerVideoRes.Prop.ID))
                    .replace(ComplexBanner.VCARD.name(), WebBanner.Prop.VCARD)

                    .replace(TextBanner.IMAGE_HASH.name(), WebBanner.Prop.IMAGE_HASH)
                    .skip(ComplexBanner.SITELINK_SET.name())

                    .replace(TextBanner.TURBO_LANDING_HREF_PARAMS.name(), WebBanner.Prop.TURBOLANDING_HREF_PARAMS)

                    .replace(TextBanner.BANNER_PRICE.name(), WebBanner.Prop.BANNER_PRICE)

                    .build();

    public static final MappingPathNodeConverter SITELINK_SET_IN_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(TextBannerPathConverter.class.getName())
                    .replace(SitelinkSet.SITELINKS.name(), WebBanner.Prop.SITELINKS)
                    .build();

    public static final MappingPathNodeConverter SITELINK_IN_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(TextBannerPathConverter.class.getName())
                    .replace(Sitelink.TITLE.name(), WebBannerSitelink.Prop.TITLE)
                    .replace(Sitelink.DESCRIPTION.name(), WebBannerSitelink.Prop.DESCRIPTION)
                    .replace(Sitelink.HREF.name(), WebBannerSitelink.Prop.HREF)
                    .replace(Sitelink.TURBO_LANDING_ID.name(),
                            asList(WebBannerSitelink.Prop.TURBOLANDING, WebBannerTurbolanding.Prop.ID))
                    .build();

    public static final MappingPathNodeConverter SITELINK_TURBOLANDING_IN_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(TextBannerPathConverter.class.getName())
                    .replace(SitelinkTurboLanding.ID.name(), WebBannerTurbolanding.Prop.ID)
                    .build();

    public static final MappingPathNodeConverter VCARD_IN_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(TextBannerPathConverter.class.getName())
                    .replace(Vcard.CAMPAIGN_ID.name(), Vcard.CAMPAIGN_ID.name())
                    .replace(Vcard.COMPANY_NAME.name(), WebBannerVcard.Prop.NAME)
                    .replace(Vcard.OGRN.name(), WebBannerVcard.Prop.OGRN)
                    .replace(Vcard.WORK_TIME.name(), WebBannerVcard.Prop.WORK_TIME)
                    .replace(Vcard.CONTACT_PERSON.name(), WebBannerVcard.Prop.CONTACT_PERSON)
                    .replace(Vcard.EMAIL.name(), WebBannerVcard.Prop.CONTACT_EMAIL)
                    .replace(Vcard.COUNTRY.name(), WebBannerVcard.Prop.COUNTRY)
                    .replace(Vcard.CITY.name(), WebBannerVcard.Prop.CITY)
                    .replace(Vcard.STREET.name(), WebBannerVcard.Prop.STREET)
                    .replace(Vcard.HOUSE.name(), WebBannerVcard.Prop.HOUSE)
                    .replace(Vcard.BUILD.name(), WebBannerVcard.Prop.BUILD)
                    .replace(Vcard.APART.name(), WebBannerVcard.Prop.APART)
                    .replace(Vcard.METRO_ID.name(), WebBannerVcard.Prop.METRO)
                    .replace(Vcard.EXTRA_MESSAGE.name(), WebBannerVcard.Prop.EXTRA_MESSAGE)

                    .skip(Vcard.PHONE.name())
                    .skip(Vcard.INSTANT_MESSENGER.name())
                    .skip(Vcard.MANUAL_POINT.name())
                    .build();

    public static final MappingPathNodeConverter VCARD_PHONE_IN_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(TextBannerPathConverter.class.getName())
                    .replace(Phone.COUNTRY_CODE.name(), WebBannerVcard.Prop.COUNTRY_CODE)
                    .replace(Phone.CITY_CODE.name(), WebBannerVcard.Prop.CITY_CODE)
                    .replace(Phone.PHONE_NUMBER.name(), WebBannerVcard.Prop.PHONE)
                    .replace(Phone.EXTENSION.name(), WebBannerVcard.Prop.EXT)
                    .build();

    public static final MappingPathNodeConverter VCARD_INSTANT_MESSENGER_IN_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(TextBannerPathConverter.class.getName())
                    .replace(InstantMessenger.TYPE.name(), WebBannerVcard.Prop.IM_CLIENT)
                    .replace(InstantMessenger.LOGIN.name(), WebBannerVcard.Prop.IM_LOGIN)
                    .build();

    public static final MappingPathNodeConverter VCARD_POINT_IN_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(TextBannerPathConverter.class.getName())
                    .replace(PointOnMap.X.name(), WebBannerVcard.Prop.MANUAL_POINT)
                    .replace(PointOnMap.Y.name(), WebBannerVcard.Prop.MANUAL_POINT)
                    .replace(PointOnMap.X1.name(), WebBannerVcard.Prop.MANUAL_BOUNDS)
                    .replace(PointOnMap.Y1.name(), WebBannerVcard.Prop.MANUAL_BOUNDS)
                    .replace(PointOnMap.X2.name(), WebBannerVcard.Prop.MANUAL_BOUNDS)
                    .replace(PointOnMap.Y2.name(), WebBannerVcard.Prop.MANUAL_BOUNDS)
                    .build();

    public static final MappingPathNodeConverter NEW_BANNER_PRICE_IN_BANNER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(TextBannerPathConverter.class.getName())
                    .replace(BannerPrice.PREFIX.name(), WebBannerPrice.Prop.PREFIX)
                    .replace(BannerPrice.PRICE.name(), WebBannerPrice.Prop.PRICE)
                    .replace(BannerPrice.PRICE_OLD.name(), WebBannerPrice.Prop.PRICE_OLD)
                    .replace(BannerPrice.CURRENCY.name(), WebBannerPrice.Prop.CURRENCY)
                    .build();
}
