package ru.yandex.direct.web.entity.banner.service;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.type.href.BannerUrlCheckService;
import ru.yandex.direct.core.entity.banner.type.href.BannersUrlHelper;
import ru.yandex.direct.core.service.urlchecker.UrlCheckResult;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.entity.banner.model.WebCheckUrlResponse;
import ru.yandex.direct.web.entity.banner.model.WebUrlCheckResult;
import ru.yandex.direct.web.validation.kernel.ValidationResultConversionService;
import ru.yandex.direct.web.validation.model.WebDefect;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@Service
@ParametersAreNonnullByDefault
public class WebBannerUrlCheckService {

    private final BannerUrlCheckService bannerUrlCheckService;
    private final ValidationResultConversionService validationResultConversionService;
    private final BannersUrlHelper bannersUrlHelper;

    @Autowired
    public WebBannerUrlCheckService(BannerUrlCheckService bannerUrlCheckService,
                                    ValidationResultConversionService validationResultConversionService,
                                    BannersUrlHelper bannersUrlHelper) {
        this.bannerUrlCheckService = bannerUrlCheckService;
        this.validationResultConversionService = validationResultConversionService;
        this.bannersUrlHelper = bannersUrlHelper;
    }

    public WebResponse checkUrls(List<String> urlsToCheck) {
        MassResult<UrlCheckResult> massResult = bannerUrlCheckService.checkUrls(urlsToCheck);
        List<WebDefect> validationErrors =
                validationResultConversionService.buildValidationResponse(massResult.getValidationResult())
                        .validationResult().getErrors();
        List<WebUrlCheckResult> results = new ArrayList<>(urlsToCheck.size());
        for (int i = 0; i < urlsToCheck.size(); i++) {
            String url = urlsToCheck.get(i);
            UrlCheckResult checkResult = massResult.get(i).getResult();
            WebUrlCheckResult result = ifNotNull(checkResult, cr -> new WebUrlCheckResult()
                    .withResult(cr.getResult())
                    .withError(ifNotNull(cr.getError(), Enum::toString))
                    .withDomain(bannersUrlHelper.extractHostFromHrefWithWwwOrNull(url)));
            results.add(result);
        }

        return new WebCheckUrlResponse()
                .withValidationErrors(validationErrors)
                .withCheckResults(results);
    }

}
