package ru.yandex.direct.web.entity.bid.presentation;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.BAD_STATUS_CAMPAIGN_ARCHIVED_ON_UPDATE_BIDS;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.FIELD_DOES_NOT_MATCH_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.FIELD_REQUIRED_FOR_CONTEXT_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.FIELD_REQUIRED_FOR_SEARCH_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.NOT_FOUND_SHOW_CONDITION_BY_PARAMETERS;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.RELEVANCE_MATCH_CANT_BE_USED_IN_SET_AUTO;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.BidsDefects2Fields.DEPENDENT_FIELD_MISSING;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.CurrencyAmountDefects.CPM_PRICE_IS_NOT_GREATER_THAN_MIN;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.CurrencyAmountDefects.CPM_PRICE_IS_NOT_SMALLER_THAN_MAX;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_GREATER_THAN_MIN;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_SMALLER_THAN_MAX;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_NOT_ALLOWED_NET_IS_SWITCHED_OFF;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_NOT_ALLOWED_NOT_DIFFERENT_PLACES;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NET_IS_SWITCHED_OFF;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NOT_DIFFERENT_PLACES;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_SEARCH_NOT_ALLOWED_SEARCH_IS_SWITCHED_OFF;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_SEARCH_IS_SWITCHED_OFF;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_NOT_ALLOWED_FOR_AUTOBUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_NOT_ALLOWED_FOR_BS_RARELY_LOADED_ADGROUP;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.CONTEXT_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.MIXED_TYPES;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.PRIORITY_HAS_WRONG_VALUE;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.PRIORITY_IS_NOT_SET_FOR_AUTO_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.PRIORITY_WONT_BE_ACCEPTED_IN_CASE_OF_NOT_AUTO_BUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.SEARCH_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.STRATEGY_IS_NOT_SET;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.POSSIBLE_ONLY_ONE_FIELD;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_AUTOBUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_MANUAL_STRATEGY;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;

public class BidDefectPresentations {

    private BidDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> bidDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(BAD_STATUS_CAMPAIGN_ARCHIVED_ON_UPDATE_BIDS,
                        defaultWebDefect())
                .register(NOT_FOUND_SHOW_CONDITION_BY_PARAMETERS,
                        defaultWebDefect())
                .register(FIELD_DOES_NOT_MATCH_STRATEGY,
                        defaultWebDefect())
                .register(FIELD_REQUIRED_FOR_SEARCH_STRATEGY,
                        defaultWebDefect())
                .register(FIELD_REQUIRED_FOR_CONTEXT_STRATEGY,
                        defaultWebDefect())
                .register(RELEVANCE_MATCH_CANT_BE_USED_IN_SET_AUTO,
                        defaultWebDefect())
                .register(DEPENDENT_FIELD_MISSING,
                        defaultWebDefect())
                .register(SEARCH_PRICE_IS_NOT_GREATER_THAN_MIN,
                        defaultWebDefect())
                .register(SEARCH_PRICE_IS_NOT_SMALLER_THAN_MAX,
                        defaultWebDefect())
                .register(CPM_PRICE_IS_NOT_GREATER_THAN_MIN,
                        defaultWebDefect())
                .register(CPM_PRICE_IS_NOT_SMALLER_THAN_MAX,
                        defaultWebDefect())
                .register(REQUIRED_AT_LEAST_ONE_OF_FIELDS,
                        defaultWebDefect())
                .register(POSSIBLE_ONLY_ONE_FIELD,
                        defaultWebDefect())
                .register(ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        defaultWebDefect())
                .register(MIXED_TYPES, defaultWebDefect())
                .register(STRATEGY_IS_NOT_SET,
                        defaultWebDefect())
                .register(SEARCH_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY,
                        defaultWebDefect())
                .register(CONTEXT_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY,
                        defaultWebDefect())
                .register(PRIORITY_IS_NOT_SET_FOR_AUTO_STRATEGY,
                        defaultWebDefect())
                .register(BID_FOR_SEARCH_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY,
                        defaultWebDefect())
                .register(PRIORITY_WONT_BE_ACCEPTED_IN_CASE_OF_NOT_AUTO_BUDGET_STRATEGY,
                        defaultWebDefect())
                .register(PRIORITY_HAS_WRONG_VALUE,
                        defaultWebDefect())
                .register(REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_MANUAL_STRATEGY,
                        defaultWebDefect())
                .register(REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_AUTOBUDGET_STRATEGY,
                        defaultWebDefect())
                .register(BID_FOR_CONTEXT_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY,
                        defaultWebDefect())
                .register(BID_NOT_ALLOWED_FOR_AUTOBUDGET_STRATEGY,
                        defaultWebDefect())
                .register(BID_NOT_ALLOWED_FOR_BS_RARELY_LOADED_ADGROUP,
                        defaultWebDefect())
                .register(BID_FOR_SEARCH_NOT_ALLOWED_SEARCH_IS_SWITCHED_OFF,
                        defaultWebDefect())
                .register(BID_FOR_CONTEXT_NOT_ALLOWED_NET_IS_SWITCHED_OFF,
                        defaultWebDefect())
                .register(BID_FOR_CONTEXT_NOT_ALLOWED_NOT_DIFFERENT_PLACES,
                        defaultWebDefect())
                .register(BID_FOR_SEARCH_WONT_BE_ACCEPTED_SEARCH_IS_SWITCHED_OFF,
                        defaultWebDefect())
                .register(BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NET_IS_SWITCHED_OFF,
                        defaultWebDefect())
                .register(BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NOT_DIFFERENT_PLACES,
                        defaultWebDefect())
                .build();
    }
}
