package ru.yandex.direct.web.entity.bidmodifier.converter;

import java.util.List;

import ru.yandex.direct.core.entity.bidmodifier.AgeType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographics;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographicsAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.GenderType;
import ru.yandex.direct.web.entity.bidmodifier.model.WebDemographicsAdjustment;
import ru.yandex.direct.web.entity.bidmodifier.model.WebDemographicsBidModifier;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class DemographicsBidModifierConverter {

    private DemographicsBidModifierConverter() {
    }

    public static BidModifierDemographics webDemographicsBidModifierToCore(WebDemographicsBidModifier webBidModifier) {
        return webBidModifier == null ? null : new BidModifierDemographics()
                .withType(BidModifierType.DEMOGRAPHY_MULTIPLIER)
                .withEnabled(Integer.valueOf(1).equals(webBidModifier.getEnabled()))
                .withDemographicsAdjustments(webDemographicsAdjustmentsToCore(webBidModifier.getAdjustments()));
    }

    private static List<BidModifierDemographicsAdjustment> webDemographicsAdjustmentsToCore(
            List<WebDemographicsAdjustment> webAdjustments) {
        return webAdjustments == null ?
                null :
                mapList(webAdjustments, DemographicsBidModifierConverter::webDemographicsAdjustmentToCore);
    }

    private static BidModifierDemographicsAdjustment webDemographicsAdjustmentToCore(
            WebDemographicsAdjustment webAdjustment) {
        return webAdjustment == null ? null : new BidModifierDemographicsAdjustment()
                .withAge(webAgeToCore(webAdjustment.getAge()))
                .withGender(webGenderToCore(webAdjustment.getGender()))
                .withPercent(webAdjustment.getPercent());
    }

    private static AgeType webAgeToCore(String age) {
        if (age == null) {
            return null;
        }

        switch (age) {
            case "all":
                return null;
            case "0-17":
                return AgeType._0_17;
            case "18-24":
                return AgeType._18_24;
            case "25-34":
                return AgeType._25_34;
            case "35-44":
                return AgeType._35_44;
            case "45-54":
                return AgeType._45_54;
            case "55-":
                return AgeType._55_;
            case "unknown":
                return AgeType.UNKNOWN;
            default:
                throw new IllegalStateException("age is not supported: " + age);
        }
    }

    private static GenderType webGenderToCore(String gender) {
        if (gender == null) {
            return null;
        }

        switch (gender) {
            case "all":
                return null;
            case "male":
                return GenderType.MALE;
            case "female":
                return GenderType.FEMALE;
            default:
                throw new IllegalStateException("gender is not supported: " + gender);
        }
    }
}
