package ru.yandex.direct.web.entity.bidmodifier.converter;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobile;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobileAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.OsType;
import ru.yandex.direct.web.entity.bidmodifier.model.WebMobileBidModifier;

public class MobileBidModifierConverter {
    private MobileBidModifierConverter() {
    }

    public static BidModifierMobile webMobileBidModifierToCore(WebMobileBidModifier webBidModifier) {
        return webBidModifier == null ? null : new BidModifierMobile()
                .withType(BidModifierType.MOBILE_MULTIPLIER)
                .withEnabled(true)
                .withMobileAdjustment(new BidModifierMobileAdjustment()
                        .withPercent(webBidModifier.getPercent())
                        .withOsType(webOsTypToCore(webBidModifier.getOsType()))
                );
    }

    private static OsType webOsTypToCore(String osType) {
        if (osType == null) {
            return null;
        }

        switch (osType) {
            case "ios":
                return OsType.IOS;
            case "android":
                return OsType.ANDROID;
            default:
                throw new IllegalStateException("osType is not supported: " + osType);
        }
    }
}
