package ru.yandex.direct.web.entity.bidmodifier.converter;

import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.bidmodifier.AbstractBidModifierRetargetingAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargeting;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.web.entity.bidmodifier.model.WebAdjustment;
import ru.yandex.direct.web.entity.bidmodifier.model.WebRetargetingBidModifier;

import static ru.yandex.direct.utils.StringUtils.ifNotBlank;

public class RetargetingBidModifierConverter {

    private RetargetingBidModifierConverter() {
    }

    public static BidModifierRetargeting webRetargetingBidModifierToCore(WebRetargetingBidModifier webBidModifier) {
        return webBidModifier == null ? null : new BidModifierRetargeting()
                .withType(BidModifierType.RETARGETING_MULTIPLIER)
                .withEnabled(Integer.valueOf(1).equals(webBidModifier.getEnabled()))
                .withRetargetingAdjustments(webRetargetingAdjustmentsToCore(webBidModifier.getAdjustments()));
    }

    private static List<AbstractBidModifierRetargetingAdjustment> webRetargetingAdjustmentsToCore(
            Map<String, WebAdjustment> webAdjustmentMap) {
        if (webAdjustmentMap == null) {
            return null;
        }

        return EntryStream.of(webAdjustmentMap)
                .mapKeyValue(RetargetingBidModifierConverter::webRetargetingAdjustmentToCore)
                .toList();
    }

    private static AbstractBidModifierRetargetingAdjustment webRetargetingAdjustmentToCore(
            String conditionId, WebAdjustment webAdjustment) {
        return new BidModifierRetargetingAdjustment()
                .withRetargetingConditionId(ifNotBlank(conditionId, Long::valueOf))
                .withPercent(webAdjustment.getPercent());
    }
}
