package ru.yandex.direct.web.entity.bidmodifier.converter;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktop;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopOnly;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopOnlyAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierSmartTV;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierSmartTVAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideoAdjustment;
import ru.yandex.direct.web.entity.bidmodifier.model.WebDesktopBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebDesktopOnlyBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebSmartTVBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebVideoBidModifier;

public class SimpleBidModifierConverters {

    private SimpleBidModifierConverters() {
    }

    public static BidModifierDesktop webDesktopBidModifierToCore(WebDesktopBidModifier webBidModifier) {
        return webBidModifier == null ? null : new BidModifierDesktop()
                .withType(BidModifierType.DESKTOP_MULTIPLIER)
                .withEnabled(true)
                .withDesktopAdjustment(new BidModifierDesktopAdjustment().withPercent(webBidModifier.getPercent()));
    }

    public static BidModifierDesktopOnly webDesktopOnlyBidModifierToCore(WebDesktopOnlyBidModifier webBidModifier) {
        return webBidModifier == null ? null : new BidModifierDesktopOnly()
                .withType(BidModifierType.DESKTOP_ONLY_MULTIPLIER)
                .withEnabled(true)
                .withDesktopOnlyAdjustment(
                        new BidModifierDesktopOnlyAdjustment().withPercent(webBidModifier.getPercent()));
    }

    public static BidModifierSmartTV webSmartTVBidModifierToCore(WebSmartTVBidModifier webBidModifier) {
        return webBidModifier == null ? null : new BidModifierSmartTV()
                .withType(BidModifierType.SMARTTV_MULTIPLIER)
                .withEnabled(true)
                .withSmartTVAdjustment(new BidModifierSmartTVAdjustment().withPercent(webBidModifier.getPercent()));
    }

    public static BidModifierVideo webVideoBidModifierToCore(WebVideoBidModifier webBidModifier) {
        return webBidModifier == null ? null : new BidModifierVideo()
                .withType(BidModifierType.VIDEO_MULTIPLIER)
                .withEnabled(true)
                .withVideoAdjustment(new BidModifierVideoAdjustment().withPercent(webBidModifier.getPercent()));
    }
}
