package ru.yandex.direct.web.entity.bidmodifier.converter;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierTablet;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTabletAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.TabletOsType;
import ru.yandex.direct.web.entity.bidmodifier.model.WebTabletBidModifier;

public class TabletBidModifierConverter {
    private TabletBidModifierConverter() {
    }

    public static BidModifierTablet webTabletBidModifierToCore(WebTabletBidModifier webBidModifier) {
        return webBidModifier == null ? null : new BidModifierTablet()
                .withType(BidModifierType.TABLET_MULTIPLIER)
                .withEnabled(true)
                .withTabletAdjustment(new BidModifierTabletAdjustment()
                        .withPercent(webBidModifier.getPercent())
                        .withOsType(webOsTypeToCore(webBidModifier.getOsType()))
                );
    }

    private static TabletOsType webOsTypeToCore(String osType) {
        if (osType == null) {
            return null;
        }

        switch (osType) {
            case "ios":
                return TabletOsType.IOS;
            case "android":
                return TabletOsType.ANDROID;
            default:
                throw new IllegalStateException("osType is not supported: " + osType);
        }
    }
}
