package ru.yandex.direct.web.entity.bidmodifier.converter;

import java.util.List;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeather;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeatherAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeatherLiteral;
import ru.yandex.direct.core.entity.bidmodifier.OperationType;
import ru.yandex.direct.core.entity.bidmodifier.WeatherType;
import ru.yandex.direct.web.entity.bidmodifier.model.WebWeatherAdjustment;
import ru.yandex.direct.web.entity.bidmodifier.model.WebWeatherBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebWeatherExpression;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class WeatherBidModifierConverter {

    private WeatherBidModifierConverter() {
    }

    public static BidModifierWeather webWeatherBidModifierToCore(WebWeatherBidModifier webBidModifier) {
        return webBidModifier == null ? null : new BidModifierWeather()
                .withType(BidModifierType.WEATHER_MULTIPLIER)
                .withEnabled(Integer.valueOf(1).equals(webBidModifier.getEnabled()))
                .withWeatherAdjustments(webWeatherAdjustmentsToCore(webBidModifier.getAdjustments()));
    }

    private static List<BidModifierWeatherAdjustment> webWeatherAdjustmentsToCore(
            List<WebWeatherAdjustment> webAdjustments) {
        return webAdjustments == null ?
                null :
                mapList(webAdjustments, WeatherBidModifierConverter::webWeatherAdjustmentsToCore);
    }


    private static BidModifierWeatherAdjustment webWeatherAdjustmentsToCore(
            WebWeatherAdjustment webAdjustment) {
        return webAdjustment == null ? null : new BidModifierWeatherAdjustment()
                .withExpression(webWeatherExpressionToCore(webAdjustment.getExpression()))
                .withPercent(webAdjustment.getPercent());
    }

    private static List<List<BidModifierWeatherLiteral>> webWeatherExpressionToCore(
            List<List<WebWeatherExpression>> webExpression) {
        return webExpression == null ?
                null :
                mapList(webExpression,
                        webExp -> mapList(webExp, WeatherBidModifierConverter::webWeatherExpressionToCore));
    }

    private static BidModifierWeatherLiteral webWeatherExpressionToCore(
            WebWeatherExpression webExpression) {
        return webExpression == null ? null : new BidModifierWeatherLiteral()
                .withParameter(webParameterToCore(webExpression.getParameter()))
                .withOperation(webOperationToCore(webExpression.getOperation()))
                .withValue(webExpression.getValue());
    }

    private static WeatherType webParameterToCore(String parameter) {
        if (parameter == null) {
            return null;
        }
        return WeatherType.valueOf(parameter.toUpperCase());
    }

    private static OperationType webOperationToCore(String operation) {
        if (operation == null) {
            return null;
        }
        return OperationType.valueOf(operation.toUpperCase());
    }
}

