package ru.yandex.direct.web.entity.bidmodifier.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebDemographicsAdjustment extends WebAdjustment {

    public static class Prop {
        private Prop() {
        }

        public static final String AGE = "age";
        public static final String GENDER = "gender";
    }

    @JsonProperty(Prop.AGE)
    private String age;

    @JsonProperty(Prop.GENDER)
    private String gender;

    public String getAge() {
        return age;
    }

    public WebDemographicsAdjustment withAge(String age) {
        this.age = age;
        return this;
    }

    public String getGender() {
        return gender;
    }

    public WebDemographicsAdjustment withGender(String gender) {
        this.gender = gender;
        return this;
    }
}
