package ru.yandex.direct.web.entity.bidmodifier.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebDemographicsBidModifier {

    public static class Prop {
        private Prop() {
        }

        public static final String ENABLED = "is_enabled";
        public static final String ADJUSTMENTS = "conditions";
    }

    @JsonProperty(Prop.ADJUSTMENTS)
    private List<WebDemographicsAdjustment> adjustments;

    @JsonProperty(Prop.ENABLED)
    private Integer enabled;

    public List<WebDemographicsAdjustment> getAdjustments() {
        return adjustments;
    }

    public WebDemographicsBidModifier withAdjustments(
            List<WebDemographicsAdjustment> adjustments) {
        this.adjustments = adjustments;
        return this;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public WebDemographicsBidModifier withEnabled(Integer enabled) {
        this.enabled = enabled;
        return this;
    }
}
