package ru.yandex.direct.web.entity.bidmodifier.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebExpressionBidModifier {
    public static class Prop {
        static final String TYPE = "type";
        static final String ENABLED = "is_enabled";
        static final String ADJUSTMENTS = "adjustments";

        private Prop() {
        }
    }

    @JsonProperty(Prop.TYPE)
    private String type;

    @JsonProperty(Prop.ADJUSTMENTS)
    private List<WebExpressionBidModifierAdjustment> adjustments;

    @JsonProperty(Prop.ENABLED)
    private Integer enabled;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public WebExpressionBidModifier withType(String type) {
        this.type = type;
        return this;
    }

    public List<WebExpressionBidModifierAdjustment> getAdjustments() {
        return adjustments;
    }

    public WebExpressionBidModifier withAdjustments(List<WebExpressionBidModifierAdjustment> adjustments) {
        this.adjustments = adjustments;
        return this;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public WebExpressionBidModifier withEnabled(Integer enabled) {
        this.enabled = enabled;
        return this;
    }
}
