package ru.yandex.direct.web.entity.bidmodifier.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebExpressionBidModifierAdjustment extends WebAdjustment {

    public static class Prop {
        static final String CONDITION = "condition";

        private Prop() {
        }
    }

    @JsonProperty(Prop.CONDITION)
    private List<List<WebExpressionBidModifierLiteral>> condition;

    public List<List<WebExpressionBidModifierLiteral>> getCondition() {
        return condition;
    }

    public WebExpressionBidModifierAdjustment withCondition(
            List<List<WebExpressionBidModifierLiteral>> condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public WebExpressionBidModifierAdjustment withPercent(Integer percent) {
        this.percent = percent;
        return this;
    }
}
