package ru.yandex.direct.web.entity.bidmodifier.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionOperator;
import ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionParameter;

public class WebExpressionBidModifierLiteral {

    public static class Prop {
        static final String PARAMETER = "parameter";
        static final String OPERATION = "operation";
        static final String VALUE = "value";

        private Prop() {
        }
    }

    @JsonProperty(Prop.PARAMETER)
    private BidModifierExpressionParameter parameter;

    @JsonProperty(Prop.OPERATION)
    private BidModifierExpressionOperator operation;

    @JsonProperty(Prop.VALUE)
    private String value;

    public BidModifierExpressionParameter getParameter() {
        return parameter;
    }

    public WebExpressionBidModifierLiteral withParameter(BidModifierExpressionParameter parameter) {
        this.parameter = parameter;
        return this;
    }

    public BidModifierExpressionOperator getOperation() {
        return operation;
    }

    public WebExpressionBidModifierLiteral withOperation(BidModifierExpressionOperator operation) {
        this.operation = operation;
        return this;
    }

    public String getValue() {
        return value;
    }

    public WebExpressionBidModifierLiteral withValue(String value) {
        this.value = value;
        return this;
    }
}
