package ru.yandex.direct.web.entity.bidmodifier.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebRetargetingBidModifier {

    public static class Prop {
        private Prop() {
        }

        public static final String ENABLED = "is_enabled";
        public static final String ADJUSTMENTS = "conditions";
    }

    @JsonProperty(Prop.ADJUSTMENTS)
    private Map<String, WebAdjustment> adjustments;

    @JsonProperty(Prop.ENABLED)
    private Integer enabled;

    public Map<String, WebAdjustment> getAdjustments() {
        return adjustments;
    }

    public WebRetargetingBidModifier withAdjustments(
            Map<String, WebAdjustment> adjustments) {
        this.adjustments = adjustments;
        return this;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public WebRetargetingBidModifier withEnabled(Integer enabled) {
        this.enabled = enabled;
        return this;
    }
}
