package ru.yandex.direct.web.entity.bidmodifier.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebTabletBidModifier {

    public static class Prop {
        private Prop() {
        }

        public static final String PERCENT = "multiplier_pct";
        public static final String OS_TYPE = "os_type";
    }

    @JsonProperty(Prop.PERCENT)
    private Integer percent;

    @JsonProperty(Prop.OS_TYPE)
    private String osType;

    public Integer getPercent() {
        return percent;
    }

    public String getOsType() {
        return osType;
    }

    public WebTabletBidModifier withPercent(Integer percent) {
        this.percent = percent;
        return this;
    }

    public WebTabletBidModifier withOsType(String osType) {
        this.osType = osType;
        return this;
    }
}
