package ru.yandex.direct.web.entity.bidmodifier.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebWeatherBidModifier {

    public static class Prop {
        private Prop() {
        }

        public static final String ENABLED = "is_enabled";
        public static final String ADJUSTMENTS = "conditions";
    }

    @JsonProperty(Prop.ADJUSTMENTS)
    private List<WebWeatherAdjustment> adjustments;

    @JsonProperty(Prop.ENABLED)
    private Integer enabled;

    public List<WebWeatherAdjustment> getAdjustments() {
        return adjustments;
    }

    public WebWeatherBidModifier withAdjustments(
            List<WebWeatherAdjustment> adjustments) {
        this.adjustments = adjustments;
        return this;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public WebWeatherBidModifier withEnabled(Integer enabled) {
        this.enabled = enabled;
        return this;
    }
}
