package ru.yandex.direct.web.entity.bidmodifier.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebWeatherExpression {

    public static class Prop {
        private Prop() {
        }

        public static final String PARAMETER = "parameter";
        public static final String OPERATION = "operation";
        public static final String VALUE = "value";
    }

    @JsonProperty(Prop.PARAMETER)
    private String parameter;

    @JsonProperty(Prop.OPERATION)
    private String operation;

    @JsonProperty(Prop.VALUE)
    private Integer value;

    public String getParameter() {
        return parameter;
    }

    public WebWeatherExpression withParameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    public String getOperation() {
        return operation;
    }

    public WebWeatherExpression withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public Integer getValue() {
        return value;
    }

    public WebWeatherExpression withValue(Integer value) {
        this.value = value;
        return this;
    }
}
