package ru.yandex.direct.web.entity.bidmodifier.presentation;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_NOT_FOUND;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_SET_NOT_FOUND;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.CONFLICT_APPLYING_CHANGES;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DEMOGRAPHICS_CONDITIONS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DEVICE_BID_MODIFIERS_ALL_ZEROS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DUPLICATE_ADJUSTMENT;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DUPLICATE_RETARGETING_CONDITION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DUPLICATE_SINGLE_ADJUSTMENT;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.EXPRESSION_ADJUSTMENT_IS_CONSTANT_FOR_ANY_VALUES;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.EXPRESSION_CONDITIONS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.GEO_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.GEO_REGIONS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.INVALID_EXPRESSION_LITERAL;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.INVALID_PARAMETER;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.INVALID_PARAMETER_VALUE;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.INVALID_PERCENT_SHOULD_BE_POSITIVE;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.NOT_SUPPORTED_MULTIPLIER;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.ONE_TYPE_USED_TWICE_IN_COMPLEX_MODIFIER;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_EXPRESSION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_OF_AGE_OR_GENDER;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.REQUIRED_EXPRESSION_FIELDS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.SETTING_OS_TYPE_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.SINGLE_VALUE_MODIFIER_ALREADY_EXISTS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.TRAFARET_POSITIONS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.UNSUPPORTED_RETARGETING_TYPE;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IdParametrized.AB_SEGMENT_NOT_FOUND;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IdParametrized.AB_SEGMENT_SECTION_NOT_FOUND;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IntegerDefects.TEMP_MUST_BE_GREATER_OR_EQUAL;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IntegerDefects.TEMP_MUST_BE_LESS_OR_EQUAL;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_ADD_ITEMS_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_GET_HARD_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_SET_ITEMS_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_TOGGLE_ITEMS_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.ModelDefects.POSSIBLE_ONLY_ONE_FIELD;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_DEMOGRAPHY_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_EXPRESSION_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_INVENTORY_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_RETARGETING_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_TRAFARET_POSITION_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_WEATHER_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.RegionIdsDefects.NONEXISTENT_REGION_IDS;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;

public class BidModifierDefectPresentations {

    private BidModifierDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> bidModifierDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(TOO_MANY_DEMOGRAPHY_CONDITIONS,
                        defaultWebDefect())
                .register(TOO_MANY_RETARGETING_CONDITIONS,
                        defaultWebDefect())
                .register(TOO_MANY_WEATHER_CONDITIONS,
                        defaultWebDefect())
                .register(TOO_MANY_EXPRESSION_CONDITIONS,
                        defaultWebDefect())
                .register(TOO_MANY_INVENTORY_CONDITIONS,
                        defaultWebDefect())
                .register(TOO_MANY_TRAFARET_POSITION_CONDITIONS,
                        defaultWebDefect())
                .register(REQUIRED_AT_LEAST_ONE_OF_FIELDS,
                        defaultWebDefect())
                .register(POSSIBLE_ONLY_ONE_FIELD,
                        defaultWebDefect())
                .register(BID_MODIFIERS_GET_HARD_LIMIT_EXCEEDED,
                        defaultWebDefect())
                .register(BID_MODIFIERS_ADD_ITEMS_LIMIT_EXCEEDED,
                        defaultWebDefect())
                .register(BID_MODIFIERS_TOGGLE_ITEMS_LIMIT_EXCEEDED,
                        defaultWebDefect())
                .register(GEO_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS,
                        defaultWebDefect())
                .register(DUPLICATE_RETARGETING_CONDITION,
                        defaultWebDefect())
                .register(DUPLICATE_ADJUSTMENT,
                        defaultWebDefect())
                .register(DUPLICATE_SINGLE_ADJUSTMENT,
                        defaultWebDefect())
                .register(REQUIRED_AT_LEAST_ONE_OF_AGE_OR_GENDER,
                        defaultWebDefect())
                .register(REQUIRED_AT_LEAST_ONE_EXPRESSION,
                        defaultWebDefect())
                .register(REQUIRED_EXPRESSION_FIELDS,
                        defaultWebDefect())
                .register(TEMP_MUST_BE_GREATER_OR_EQUAL,
                        defaultWebDefect())
                .register(INVALID_PARAMETER_VALUE,
                        defaultWebDefect())
                .register(INVALID_PARAMETER,
                        defaultWebDefect())
                .register(TEMP_MUST_BE_LESS_OR_EQUAL,
                        defaultWebDefect())
                .register(DEMOGRAPHICS_CONDITIONS_INTERSECTION,
                        defaultWebDefect())
                .register(INVALID_PERCENT_SHOULD_BE_POSITIVE,
                        defaultWebDefect())
                .register(NOT_SUPPORTED_MULTIPLIER,
                        defaultWebDefect())
                .register(GEO_REGIONS_INTERSECTION,
                        defaultWebDefect())
                .register(TRAFARET_POSITIONS_INTERSECTION,
                        defaultWebDefect())
                .register(SINGLE_VALUE_MODIFIER_ALREADY_EXISTS,
                        defaultWebDefect())
                .register(CONFLICT_APPLYING_CHANGES,
                        defaultWebDefect())
                .register(ADJUSTMENT_NOT_FOUND,
                        defaultWebDefect())
                .register(ADJUSTMENT_SET_NOT_FOUND,
                        defaultWebDefect())
                .register(BID_MODIFIERS_SET_ITEMS_LIMIT_EXCEEDED,
                        defaultWebDefect())
                .register(NONEXISTENT_REGION_IDS,
                        defaultWebDefect())
                .register(AB_SEGMENT_BID_MODIFIERS_INTERSECTION,
                        defaultWebDefect())
                .register(AB_SEGMENT_NOT_FOUND,
                        defaultWebDefect())
                .register(AB_SEGMENT_SECTION_NOT_FOUND,
                        defaultWebDefect())
                .register(AB_SEGMENT_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS,
                        defaultWebDefect())
                .register(UNSUPPORTED_RETARGETING_TYPE,
                        defaultWebDefect())
                .register(DEVICE_BID_MODIFIERS_ALL_ZEROS,
                        defaultWebDefect())
                .register(SETTING_OS_TYPE_NOT_ALLOWED,
                        defaultWebDefect())
                .register(INVALID_EXPRESSION_LITERAL,
                        defaultWebDefect())
                .register(EXPRESSION_ADJUSTMENT_IS_CONSTANT_FOR_ANY_VALUES,
                        defaultWebDefect())
                .register(EXPRESSION_CONDITIONS_INTERSECTION,
                        defaultWebDefect())
                .register(ONE_TYPE_USED_TWICE_IN_COMPLEX_MODIFIER,
                        defaultWebDefect())

                .build();
    }
}
