package ru.yandex.direct.web.entity.bidmodifier.presentation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographics;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographicsAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktop;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobile;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobileAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargeting;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideoAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeather;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeatherAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeatherLiteral;
import ru.yandex.direct.core.entity.bidmodifier.ComplexBidModifier;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.adgroup.model.WebAdGroupBidModifiers;
import ru.yandex.direct.web.entity.bidmodifier.model.WebAdjustment;
import ru.yandex.direct.web.entity.bidmodifier.model.WebDemographicsAdjustment;
import ru.yandex.direct.web.entity.bidmodifier.model.WebDemographicsBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebMobileBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebRetargetingBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebWeatherAdjustment;
import ru.yandex.direct.web.entity.bidmodifier.model.WebWeatherBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebWeatherExpression;

@ParametersAreNonnullByDefault
public class BidModifierPathConverters {

    private BidModifierPathConverters() {
    }

    public static final MappingPathNodeConverter COMPLEX_BID_MODIFIER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(ComplexBidModifier.RETARGETING_MODIFIER.name(),
                            WebAdGroupBidModifiers.Prop.RETARGETING_BID_MODIFIER)
                    .replace(ComplexBidModifier.DEMOGRAPHY_MODIFIER.name(),
                            WebAdGroupBidModifiers.Prop.DEMOGRAPHICS_BID_MODIFIER)
                    .replace(ComplexBidModifier.MOBILE_MODIFIER.name(),
                            WebAdGroupBidModifiers.Prop.MOBILE_BID_MODIFIER)
                    .replace(ComplexBidModifier.VIDEO_MODIFIER.name(),
                            WebAdGroupBidModifiers.Prop.VIDEO_BID_MODIFIER)
                    .build();

    public static final MappingPathNodeConverter RETARGETING_BID_MODIFIER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierRetargeting.RETARGETING_ADJUSTMENTS.name(),
                            WebRetargetingBidModifier.Prop.ADJUSTMENTS)
                    .replace(BidModifierRetargeting.ENABLED.name(),
                            WebRetargetingBidModifier.Prop.ENABLED)
                    .build();

    public static final MappingPathNodeConverter RETARGETING_ADJUSTMENT_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierRetargetingAdjustment.RETARGETING_CONDITION_ID.name(),
                            "ret_cond_id")
                    .replace(BidModifierRetargetingAdjustment.PERCENT.name(),
                            WebAdjustment.Prop.PERCENT)
                    .build();

    public static final MappingPathNodeConverter DEMOGRAPHY_BID_MODIFIER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierDemographics.DEMOGRAPHICS_ADJUSTMENTS.name(),
                            WebDemographicsBidModifier.Prop.ADJUSTMENTS)
                    .replace(BidModifierDemographics.ENABLED.name(),
                            WebDemographicsBidModifier.Prop.ENABLED)
                    .build();

    public static final MappingPathNodeConverter DEMOGRAPHY_ADJUSTMENT_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierDemographicsAdjustment.AGE.name(),
                            WebDemographicsAdjustment.Prop.AGE)
                    .replace(BidModifierDemographicsAdjustment.GENDER.name(),
                            WebDemographicsAdjustment.Prop.GENDER)
                    .replace(BidModifierDemographicsAdjustment.PERCENT.name(),
                            WebAdjustment.Prop.PERCENT)
                    .build();

    public static final MappingPathNodeConverter VIDEO_BID_MODIFIER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .skip(BidModifierVideo.VIDEO_ADJUSTMENT.name())
                    .build();

    public static final MappingPathNodeConverter VIDEO_ADJUSTMENT_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierVideoAdjustment.PERCENT.name(),
                            WebAdjustment.Prop.PERCENT)
                    .build();

    public static final MappingPathNodeConverter MOBILE_BID_MODIFIER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .skip(BidModifierMobile.MOBILE_ADJUSTMENT.name())
                    .build();

    public static final MappingPathNodeConverter MOBILE_ADJUSTMENT_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierMobileAdjustment.OS_TYPE.name(),
                            WebMobileBidModifier.Prop.OS_TYPE)
                    .replace(BidModifierMobileAdjustment.PERCENT.name(),
                            WebAdjustment.Prop.PERCENT)
                    .build();

    public static final MappingPathNodeConverter DESKTOP_BID_MODIFIER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .skip(BidModifierDesktop.DESKTOP_ADJUSTMENT.name())
                    .build();

    public static final MappingPathNodeConverter DESKTOP_ADJUSTMENT_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierMobileAdjustment.PERCENT.name(),
                            WebAdjustment.Prop.PERCENT)
                    .build();

    public static final MappingPathNodeConverter WEATHER_BID_MODIFIER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierWeather.WEATHER_ADJUSTMENTS.name(),
                            WebWeatherBidModifier.Prop.ADJUSTMENTS)
                    .replace(BidModifierWeather.ENABLED.name(),
                            WebWeatherBidModifier.Prop.ENABLED)
                    .build();

    public static final MappingPathNodeConverter WEATHER_ADJUSTMENT_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierWeatherAdjustment.EXPRESSION.name(),
                            WebWeatherAdjustment.Prop.EXPRESSION)
                    .replace(BidModifierWeatherAdjustment.PERCENT.name(),
                            WebAdjustment.Prop.PERCENT)
                    .build();

    public static final MappingPathNodeConverter WEATHER_LITERAL_PATH_CONVERTER =
            MappingPathNodeConverter.builder(BidModifierPathConverters.class.getName())
                    .replace(BidModifierWeatherLiteral.PARAMETER.name(),
                            WebWeatherExpression.Prop.PARAMETER)
                    .replace(BidModifierWeatherLiteral.OPERATION.name(),
                            WebWeatherExpression.Prop.OPERATION)
                    .replace(BidModifierWeatherLiteral.VALUE.name(),
                            WebWeatherExpression.Prop.VALUE)
                    .build();
}
