package ru.yandex.direct.web.entity.callout.presentation;

import ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.AD_EXTENSION_ALREADY_EXISTS;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.AD_EXTENSION_IS_DELETED;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.AD_EXTENSION_IS_IN_USE;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.CALLOUT_TEXT_IS_EMPTY;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.DUPLICATE_CALLOUT_TEXTS;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Numbers.MAX_CLIENT_CALLOUTS;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Numbers.MAX_CLIENT_CALLOUTS_WITH_DELETED;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Strings.ALLOWED_SYMBOLS_CALLOUT_TEXT;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Strings.CALLOUT_TEXT_LENGTH_EXCEEDED;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class CalloutDefectPresentations {

    private CalloutDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> calloutPresentationRegistry() {
        CommonDefectTranslations commonTranslations = CommonDefectTranslations.INSTANCE;
        CalloutDefectTranslations translations = CalloutDefectTranslations.INSTANCE;
        return DefaultDefectPresentationRegistry.builder()
                .register(MAX_CLIENT_CALLOUTS,
                        paramWebDefect(di -> translations.maxCalloutsOnClient(di.getDefect().params().getMax())))
                .register(MAX_CLIENT_CALLOUTS_WITH_DELETED,
                        paramWebDefect(
                                di -> translations.maxCalloutsOnClientWithDeleted(di.getDefect().params().getMax())))
                .register(DUPLICATE_CALLOUT_TEXTS,
                        webDefect(translations.duplicateCalloutTexts()))
                .register(ALLOWED_SYMBOLS_CALLOUT_TEXT,
                        webDefect(translations.notAllowedSymbolsInCalloutText()))
                .register(AD_EXTENSION_ALREADY_EXISTS,
                        webDefect(translations.adExtensionAlreadyExists()))

                .register(AD_EXTENSION_IS_IN_USE,
                        webDefect(translations.adExtensionIsInUse()))
                .register(AD_EXTENSION_IS_DELETED,
                        webDefect(commonTranslations.objectAlreadyMarkedAsDeletedDetailed()))

                .register(CALLOUT_TEXT_IS_EMPTY,
                        webDefect(translations.emptyValue()))
                .register(CALLOUT_TEXT_LENGTH_EXCEEDED,
                        paramWebDefect(di -> translations.calloutTextLengthExceeded(di.getValue().toString(),
                                di.getDefect().params().getMaxLength())))
                .build();
    }
}
