package ru.yandex.direct.web.entity.campaign.controller;


import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.direct.web.annotations.AllowedOperatorRoles;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.campaign.model.DeleteCampMetrikaCountersWebRequest;
import ru.yandex.direct.web.entity.campaign.model.GetCampaignExtendedTypeResponse;
import ru.yandex.direct.web.entity.campaign.model.UpdateCampMetrikaCountersWebRequest;
import ru.yandex.direct.web.entity.campaign.service.WebCampMetrikaCountersService;
import ru.yandex.direct.web.entity.campaign.service.WebCampaignService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;


@Controller
@RequestMapping(value = "/campaign",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "campaign")
public class CampaignController {
    private final WebCampMetrikaCountersService webCampMetrikaCountersService;
    private final WebCampaignService webCampaignService;
    private final DirectWebAuthenticationSource authenticationSource;

    @Autowired
    public CampaignController(
            WebCampMetrikaCountersService webCampMetrikaCountersService,
            WebCampaignService webCampaignService,
            DirectWebAuthenticationSource authenticationSource) {
        this.authenticationSource = authenticationSource;
        this.webCampMetrikaCountersService = webCampMetrikaCountersService;
        this.webCampaignService = webCampaignService;
    }

    @ApiOperation(
            value = "addMetrikaCounters",
            httpMethod = "POST",
            nickname = "addMetrikaCounters"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/metrika_counters/add", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse addMetrikaCounters(
            @RequestBody UpdateCampMetrikaCountersWebRequest webRequest,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return webCampMetrikaCountersService.addCampMetrikaCounters(webRequest);
    }


    @ApiOperation(
            value = "replaceMetrikaCounters",
            httpMethod = "POST",
            nickname = "replaceMetrikaCounters"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/metrika_counters/replace", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse replaceMetrikaCounters(
            @RequestBody UpdateCampMetrikaCountersWebRequest webRequest,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return webCampMetrikaCountersService.replaceCampMetrikaCounters(webRequest);
    }


    @ApiOperation(
            value = "deleteMetrikaCounters",
            httpMethod = "POST",
            nickname = "deleteMetrikaCounters"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/metrika_counters/delete", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse deleteMetrikaCounters(
            @RequestBody DeleteCampMetrikaCountersWebRequest webRequest,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return webCampMetrikaCountersService.deleteCampMetrikaCounters(webRequest);
    }

    @ApiOperation(
            value = "searchDealCampaigns",
            httpMethod = "GET",
            nickname = "searchDealCampaigns"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/search_deal_campaigns", method = RequestMethod.GET)
    @ResponseBody
    @AllowedOperatorRoles({RbacRole.SUPER, RbacRole.SUPERREADER, RbacRole.AGENCY})
    public WebResponse searchDealCampaigns(
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN) String subjectLogin) {
        return webCampaignService.searchDealCampaigns();
    }


    @ApiOperation(
            value = "getBrandLift",
            httpMethod = "GET",
            nickname = "getBrandLift"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeRead
    @DisableAutoCaptcha
    @RequestMapping(path = "/get_brand_lift", method = RequestMethod.GET)
    @ResponseBody
    public WebResponse getBrandLift(
            @RequestParam(value = PARAMETER_ULOGIN) String subjectLogin,
            @RequestParam(value = "cids") List<Long> cids) {
        DirectAuthentication authentication = authenticationSource.getAuthentication();
        ClientId clientId = authentication.getSubjectUser().getClientId();
        User operator = authentication.getOperator();
        return webCampaignService.getBrandLift(cids, operator.getUid(), clientId);
    }

    @ApiOperation(
            value = "deleteBrandLift",
            httpMethod = "POST",
            nickname = "deleteBrandLift"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/delete_brand_lift", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse deleteBrandLift(
            @RequestBody List<Long> cids,
            @RequestParam(value = PARAMETER_ULOGIN) String subjectLogin
    ) {
        DirectAuthentication authentication = authenticationSource.getAuthentication();
        ClientId clientId = authentication.getSubjectUser().getClientId();
        User operator = authentication.getOperator();
        return webCampaignService.deleteBrandLift(cids, operator.getUid(), clientId);
    }


    @ApiOperation(
            value = "Get campaign type",
            httpMethod = "GET",
            nickname = "type"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeRead
    @DisableAutoCaptcha
    @RequestMapping(path = "/type", method = RequestMethod.GET)
    @ResponseBody
    public WebResponse getCampaignType(
            @RequestParam(value = "campaign_id") Long campaignId,
            @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        DirectAuthentication authentication = authenticationSource.getAuthentication();
        ClientId clientId = authentication.getSubjectUser().getClientId();
        User operator = authentication.getOperator();
        return webCampaignService.getCampaignType(campaignId, operator.getUid(), clientId);
    }

    @ApiOperation(
            value = "Get campaign type",
            httpMethod = "GET",
            nickname = "type"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = GetCampaignExtendedTypeResponse.class)
            }
    )
    @PreAuthorizeRead
    @DisableAutoCaptcha
    @RequestMapping(path = "/extended_type", method = RequestMethod.GET)
    @ResponseBody
    public WebResponse getCampaignExtendedType(
            @RequestParam(value = "campaign_id") Long campaignId,
            @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        DirectAuthentication authentication = authenticationSource.getAuthentication();
        ClientId clientId = authentication.getSubjectUser().getClientId();
        User operator = authentication.getOperator();
        return webCampaignService.getCampaignExtendedType(campaignId, operator.getUid(), clientId);
    }
}
