package ru.yandex.direct.web.entity.campaign.controller;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.service.CampaignService;
import ru.yandex.direct.core.entity.page.service.PageService;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.campaign.model.DisabledDomainsWeb;
import ru.yandex.direct.web.entity.campaign.model.GetInternalPagesDomainsRequest;
import ru.yandex.direct.web.validation.kernel.ValidationResultConversionService;

import static ru.yandex.direct.core.validation.ValidationUtils.hasValidationIssues;
import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@RequestMapping(value = "/disabled-domains",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "disabledVideoDomainsController")
public class DisabledVideoDomainsController {

    private final CampaignService campaignService;
    private final PageService pageService;
    private final DirectWebAuthenticationSource authenticationSource;
    private final ValidationResultConversionService validationResultConversionService;

    @Autowired
    public DisabledVideoDomainsController(CampaignService campaignService,
                                          PageService pageService,
                                          DirectWebAuthenticationSource authenticationSource,
                                          ValidationResultConversionService validationResultConversionService) {
        this.campaignService = campaignService;
        this.pageService = pageService;
        this.authenticationSource = authenticationSource;
        this.validationResultConversionService = validationResultConversionService;
    }

    @ApiOperation(
            value = "disableVideoDomains",
            httpMethod = "POST",
            nickname = "disableVideoDomains"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/video", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse disableVideoDomain(
            @RequestBody DisabledDomainsWeb disabledDomainsWeb,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String ulogin) {
        DirectAuthentication authentication = authenticationSource.getAuthentication();
        long operatorUid = authentication.getOperator().getUid();
        ClientId clientId = authentication.getSubjectUser().getClientId();
        ValidationResult<Campaign, Defect> result =
                campaignService.addOrRemoveDisabledVideoDomains(operatorUid, clientId,
                        disabledDomainsWeb.getCampaignId(), disabledDomainsWeb.getDisabledDomains(),
                        disabledDomainsWeb.isDisable());
        if (hasValidationIssues(result)) {
            return validationResultConversionService.buildValidationResponse(result);
        }
        return new WebSuccessResponse();
    }

    @ApiOperation(
            value = "getInternalPagesDomains",
            httpMethod = "POST",
            nickname = "getInternalPagesDomains"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @DisableAutoCaptcha
    @RequestMapping(path = "/get_internal_pages_domains", method = RequestMethod.POST)
    @ResponseBody
    public List<String> getInternalPagesDomains(
            @RequestBody GetInternalPagesDomainsRequest request,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return pageService.getInternalPagesDomains(request.getDomains());
    }
}
