package ru.yandex.direct.web.entity.campaign.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;

public class BrandSurveyStatusWeb {

    public static final String SURVEY_STATUS_DAILY = "survey_status_daily";
    public static final String REASON_IDS = "reason_ids";
    public static final String BRAND_SURVEY_STOP_REASONS_DAILY = "brand_survey_stop_reasons_daily";
    public static final String SUM_SPENT_BY_DAY = "sum_spent_by_day";
    public static final String SUM_SPENT_BY_TOTAL_PERIOD = "sum_spent_by_total_period";


    @JsonProperty(SURVEY_STATUS_DAILY)
    private SurveyStatusWeb surveyStatusDaily;

    @JsonProperty(REASON_IDS)
    private List<Long> reasonIds;

    @JsonProperty(BRAND_SURVEY_STOP_REASONS_DAILY)
    private Set<BrandSurveyStopReasonWeb> brandSurveyStopReasonsDaily;

    @JsonProperty(SUM_SPENT_BY_DAY)
    private BigDecimal sumSpentByDay;

    @JsonProperty(SUM_SPENT_BY_TOTAL_PERIOD)
    private BigDecimal sumSpentByTotalPeriod;

    public SurveyStatusWeb getSurveyStatusDaily() {
        return surveyStatusDaily;
    }

    public void setSurveyStatusDaily(SurveyStatusWeb surveyStatusDaily) {
        this.surveyStatusDaily = surveyStatusDaily;
    }

    public BrandSurveyStatusWeb withSurveyStatusDaily(SurveyStatusWeb surveyStatusDaily) {
        this.surveyStatusDaily = surveyStatusDaily;
        return this;
    }

    public List<Long> getReasonIds() {
        return reasonIds;
    }

    public void setReasonIds(List<Long> reasonIds) {
        this.reasonIds = reasonIds;
    }

    public BrandSurveyStatusWeb withReasonIds(List<Long> reasonIds) {
        this.reasonIds = reasonIds;
        return this;
    }

    public Set<BrandSurveyStopReasonWeb> getBrandSurveyStopReasonsDaily() {
        return brandSurveyStopReasonsDaily;
    }

    public void setBrandSurveyStopReasonsDaily(Set<BrandSurveyStopReasonWeb> brandSurveyStopReasonsDaily) {
        this.brandSurveyStopReasonsDaily = brandSurveyStopReasonsDaily;
    }

    public BrandSurveyStatusWeb withBrandSurveyStopReasonsDaily(Set<BrandSurveyStopReasonWeb> brandSurveyStopReasonsDaily) {
        this.brandSurveyStopReasonsDaily = brandSurveyStopReasonsDaily;
        return this;
    }

    public BigDecimal getSumSpentByDay() {
        return sumSpentByDay;
    }

    public void setSumSpentByDay(BigDecimal sumSpentByDay) {
        this.sumSpentByDay = sumSpentByDay;
    }

    public BrandSurveyStatusWeb withSumSpentByDay(BigDecimal sumSpentByDay) {
        this.sumSpentByDay = sumSpentByDay;
        return this;
    }

    public BigDecimal getSumSpentByTotalPeriod() {
        return sumSpentByTotalPeriod;
    }

    public BrandSurveyStatusWeb withSumSpentByTotalPeriod(BigDecimal sumSpentByTotalPeriod) {
        this.sumSpentByTotalPeriod = sumSpentByTotalPeriod;
        return this;
    }
}
