package ru.yandex.direct.web.entity.campaign.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class CampaignWithDealsWeb {

    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DEAL_IDS = "deal_ids";
    public static final String STATUS_MODERATE = "status_moderate";

    @JsonProperty(ID)
    private Long id;

    @JsonProperty(NAME)
    private String name;

    @JsonProperty(DEAL_IDS)
    private List<Long> dealIds;

    @JsonProperty(STATUS_MODERATE)
    private String statusModerate;

    public Long getId() {
        return id;
    }

    public CampaignWithDealsWeb withId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public CampaignWithDealsWeb withName(String name) {
        this.name = name;
        return this;
    }

    public List<Long> getDealIds() {
        return dealIds;
    }

    public CampaignWithDealsWeb withDealIds(List<Long> dealIds) {
        this.dealIds = dealIds;
        return this;
    }

    public String getStatusModerate() {
        return statusModerate;
    }

    public CampaignWithDealsWeb withStatusModerate(String statusModerate) {
        this.statusModerate = statusModerate;
        return this;
    }
}
