package ru.yandex.direct.web.entity.campaign.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.web.entity.SuccessResponse;

public class GetCampaignExtendedTypeResponse extends SuccessResponse<GetCampaignExtendedTypeResponse.Data> {

    public GetCampaignExtendedTypeResponse(
            CampaignType campaignType,
            CampaignSource campaignSource,
            boolean generated
    ) {
        super(new Data(campaignType, campaignSource, generated));
    }

    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class Data {
        private final CampaignType campaignType;
        private final CampaignSource campaignSource;
        private final boolean generated;

        public Data(CampaignType campaignType, CampaignSource campaignSource, boolean generated) {
            this.campaignType = campaignType;
            this.campaignSource = campaignSource;
            this.generated = generated;
        }

        public CampaignType getCampaignType() {
            return campaignType;
        }

        public CampaignSource getCampaignSource() {
            return campaignSource;
        }

        public boolean isGenerated() {
            return generated;
        }
    }
}
